/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.memcached.protocol;

import java.io.Serializable;
import org.openspaces.memcached.protocol.CommandMessage;

public final class SessionStatus
implements Serializable {
    private static final long serialVersionUID = 8948155047611447607L;
    public State state;
    public int bytesNeeded;
    public CommandMessage cmd;

    public SessionStatus() {
        this.ready();
    }

    public SessionStatus ready() {
        this.cmd = null;
        this.bytesNeeded = -1;
        this.state = State.READY;
        return this;
    }

    public SessionStatus processing() {
        this.state = State.PROCESSING;
        return this;
    }

    public SessionStatus processingMultiline() {
        this.state = State.PROCESSING_MULTILINE;
        return this;
    }

    public SessionStatus needMore(int size, CommandMessage cmd) {
        this.cmd = cmd;
        this.bytesNeeded = size;
        this.state = State.WAITING_FOR_DATA;
        return this;
    }

    public static enum State {
        WAITING_FOR_DATA,
        READY,
        PROCESSING,
        PROCESSING_MULTILINE;

    }
}

