/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.memcached.protocol;

import com.j_spaces.kernel.threadpool.DynamicExecutors;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.openspaces.memcached.SpaceCache;
import org.openspaces.memcached.protocol.MemcachedCommandHandler;
import org.openspaces.memcached.protocol.SessionStatus;
import org.openspaces.memcached.protocol.binary.MemcachedBinaryCommandDecoder;
import org.openspaces.memcached.protocol.binary.MemcachedBinaryResponseEncoder;
import org.openspaces.memcached.protocol.text.MemcachedCommandDecoder;
import org.openspaces.memcached.protocol.text.MemcachedFrameDecoder;
import org.openspaces.memcached.protocol.text.MemcachedResponseEncoder;

public class UnifiedProtocolDecoder
extends FrameDecoder {
    private final SpaceCache cache;
    private final DefaultChannelGroup channelGroup;
    public final String version;
    public final int idle_limit;
    public final boolean verbose;
    private final boolean threaded;

    public UnifiedProtocolDecoder(SpaceCache cache, DefaultChannelGroup channelGroup, String version, int idle_limit, boolean verbose, boolean threaded) {
        this.cache = cache;
        this.channelGroup = channelGroup;
        this.version = version;
        this.idle_limit = idle_limit;
        this.verbose = verbose;
        this.threaded = threaded;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < 1) {
            return null;
        }
        short magic = buffer.getUnsignedByte(buffer.readerIndex());
        if (magic == 128) {
            ChannelPipeline p = ctx.getPipeline();
            p.addLast("decoder", (ChannelHandler)new MemcachedBinaryCommandDecoder());
            if (this.threaded) {
                p.addLast("executor", (ChannelHandler)new ExecutionHandler((Executor)Executors.newCachedThreadPool(DynamicExecutors.daemonThreadFactory((String)"memcached"))));
            }
            p.addLast("handler", (ChannelHandler)new MemcachedCommandHandler(this.cache, this.version, this.verbose, this.idle_limit, this.channelGroup));
            p.addLast("encoder", (ChannelHandler)new MemcachedBinaryResponseEncoder());
            p.remove((ChannelHandler)this);
        } else {
            SessionStatus status = new SessionStatus().ready();
            ChannelPipeline p = ctx.getPipeline();
            p.addLast("frame", (ChannelHandler)new MemcachedFrameDecoder(status, 0x2000000));
            p.addLast("decoder", (ChannelHandler)new MemcachedCommandDecoder(status));
            if (this.threaded) {
                p.addLast("executor", (ChannelHandler)new ExecutionHandler((Executor)Executors.newCachedThreadPool(DynamicExecutors.daemonThreadFactory((String)"memcached"))));
            }
            p.addLast("handler", (ChannelHandler)new MemcachedCommandHandler(this.cache, this.version, this.verbose, this.idle_limit, this.channelGroup));
            p.addLast("encoder", (ChannelHandler)new MemcachedResponseEncoder());
            p.remove((ChannelHandler)this);
        }
        return buffer.readBytes(buffer.readableBytes());
    }
}

