/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.memcached.protocol.binary;

import java.nio.ByteOrder;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.openspaces.memcached.LocalCacheElement;
import org.openspaces.memcached.protocol.Op;
import org.openspaces.memcached.protocol.ResponseMessage;
import org.openspaces.memcached.protocol.binary.MemcachedBinaryCommandDecoder;
import org.openspaces.memcached.protocol.exceptions.UnknownCommandException;

@ChannelHandler.Sharable
public class MemcachedBinaryResponseEncoder
extends SimpleChannelUpstreamHandler {
    private ConcurrentHashMap<Integer, ChannelBuffer> corkedBuffers = new ConcurrentHashMap();
    protected static final Log logger = LogFactory.getLog(MemcachedBinaryResponseEncoder.class);

    public ResponseCode getStatusCode(ResponseMessage command) {
        Op cmd = command.cmd.op;
        switch (cmd) {
            case GET: 
            case GETS: {
                if (command.elements == null || command.elements.length == 1 && command.elements[0] == null) {
                    return ResponseCode.KEYNF;
                }
                return ResponseCode.OK;
            }
            case SET: 
            case CAS: 
            case ADD: 
            case REPLACE: 
            case APPEND: 
            case PREPEND: {
                switch (command.response) {
                    case EXISTS: {
                        return ResponseCode.KEYEXISTS;
                    }
                    case NOT_FOUND: {
                        return ResponseCode.KEYNF;
                    }
                    case NOT_STORED: {
                        return ResponseCode.NOT_STORED;
                    }
                    case STORED: {
                        return ResponseCode.OK;
                    }
                }
                break;
            }
            case INCR: 
            case DECR: {
                return command.incrDecrResponse == null ? ResponseCode.KEYNF : ResponseCode.OK;
            }
            case DELETE: {
                switch (command.deleteResponse) {
                    case DELETED: {
                        return ResponseCode.OK;
                    }
                    case NOT_FOUND: {
                        return ResponseCode.KEYNF;
                    }
                }
                break;
            }
            case STATS: {
                return ResponseCode.OK;
            }
            case VERSION: {
                return ResponseCode.OK;
            }
            case FLUSH_ALL: {
                return ResponseCode.OK;
            }
        }
        return ResponseCode.UNKNOWN;
    }

    public ChannelBuffer constructHeader(MemcachedBinaryCommandDecoder.BinaryOp bcmd, ChannelBuffer extrasBuffer, ChannelBuffer keyBuffer, ChannelBuffer valueBuffer, short responseCode, int opaqueValue, long casUnique) {
        ChannelBuffer header = ChannelBuffers.buffer((ByteOrder)ByteOrder.BIG_ENDIAN, (int)24);
        header.writeByte(-127);
        header.writeByte((int)bcmd.getCode());
        short keyLength = (short)(keyBuffer != null ? keyBuffer.capacity() : 0);
        header.writeShort((int)keyLength);
        int extrasLength = extrasBuffer != null ? extrasBuffer.capacity() : 0;
        header.writeByte((int)((byte)extrasLength));
        header.writeByte(0);
        header.writeShort((int)responseCode);
        int dataLength = valueBuffer != null ? valueBuffer.capacity() : 0;
        header.writeInt(dataLength + keyLength + extrasLength);
        header.writeInt(opaqueValue);
        header.writeLong(casUnique);
        return header;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        block4: {
            try {
                throw e.getCause();
            }
            catch (UnknownCommandException unknownCommand) {
                if (ctx.getChannel().isOpen()) {
                    ctx.getChannel().write((Object)this.constructHeader(MemcachedBinaryCommandDecoder.BinaryOp.Noop, null, null, null, (short)129, 0, 0L));
                }
            }
            catch (Throwable err) {
                logger.error((Object)"error", err);
                if (!ctx.getChannel().isOpen()) break block4;
                ctx.getChannel().close();
            }
        }
    }

    public void messageReceived(ChannelHandlerContext channelHandlerContext, MessageEvent messageEvent) throws Exception {
        ResponseMessage command = (ResponseMessage)messageEvent.getMessage();
        Object additional = messageEvent.getMessage();
        MemcachedBinaryCommandDecoder.BinaryOp bcmd = MemcachedBinaryCommandDecoder.BinaryOp.forCommandMessage(command.cmd);
        ChannelBuffer extrasBuffer = null;
        ChannelBuffer keyBuffer = null;
        if (bcmd.isAddKeyToResponse() && command.cmd.keys != null && command.cmd.keys.size() != 0) {
            keyBuffer = ChannelBuffers.wrappedBuffer((byte[])command.cmd.keys.get((int)0).bytes);
        }
        ChannelBuffer valueBuffer = null;
        if (command.elements != null) {
            extrasBuffer = ChannelBuffers.buffer((ByteOrder)ByteOrder.BIG_ENDIAN, (int)4);
            LocalCacheElement element = command.elements[0];
            extrasBuffer.writeShort((int)((short)(element != null ? element.getExpire() : 0)));
            extrasBuffer.writeShort((int)((short)(element != null ? element.getFlags() : 0)));
            if (command.cmd.op == Op.GET || command.cmd.op == Op.GETS) {
                valueBuffer = element != null ? ChannelBuffers.wrappedBuffer((ByteOrder)ByteOrder.BIG_ENDIAN, (byte[])element.getData()) : ChannelBuffers.buffer((int)0);
            } else if (command.cmd.op == Op.INCR || command.cmd.op == Op.DECR) {
                valueBuffer = ChannelBuffers.buffer((ByteOrder)ByteOrder.BIG_ENDIAN, (int)8);
                valueBuffer.writeLong((long)command.incrDecrResponse.intValue());
            }
        } else if (command.cmd.op == Op.INCR || command.cmd.op == Op.DECR) {
            valueBuffer = ChannelBuffers.buffer((ByteOrder)ByteOrder.BIG_ENDIAN, (int)8);
            valueBuffer.writeLong((long)command.incrDecrResponse.intValue());
        }
        long casUnique = 0L;
        if (command.elements != null && command.elements.length != 0 && command.elements[0] != null) {
            casUnique = command.elements[0].getCasUnique();
        }
        if (command.cmd.op == Op.STATS) {
            if (this.corkedBuffers.containsKey(command.cmd.opaque)) {
                this.uncork(command.cmd.opaque, messageEvent.getChannel());
            }
            for (Map.Entry<String, Set<String>> statsEntries : command.stats.entrySet()) {
                for (String stat : statsEntries.getValue()) {
                    keyBuffer = ChannelBuffers.wrappedBuffer((ByteOrder)ByteOrder.BIG_ENDIAN, (byte[])statsEntries.getKey().getBytes("US-ASCII"));
                    valueBuffer = ChannelBuffers.wrappedBuffer((ByteOrder)ByteOrder.BIG_ENDIAN, (byte[])stat.getBytes("US-ASCII"));
                    ChannelBuffer headerBuffer = this.constructHeader(bcmd, extrasBuffer, keyBuffer, valueBuffer, this.getStatusCode(command).getCode(), command.cmd.opaque, casUnique);
                    this.writePayload(messageEvent, extrasBuffer, keyBuffer, valueBuffer, headerBuffer);
                }
            }
            keyBuffer = null;
            valueBuffer = null;
            ChannelBuffer headerBuffer = this.constructHeader(bcmd, extrasBuffer, keyBuffer, valueBuffer, this.getStatusCode(command).getCode(), command.cmd.opaque, casUnique);
            this.writePayload(messageEvent, extrasBuffer, keyBuffer, valueBuffer, headerBuffer);
        } else {
            ChannelBuffer headerBuffer = this.constructHeader(bcmd, extrasBuffer, keyBuffer, valueBuffer, this.getStatusCode(command).getCode(), command.cmd.opaque, casUnique);
            if (bcmd.isNoreply()) {
                int totalCapacity = headerBuffer.capacity() + (extrasBuffer != null ? extrasBuffer.capacity() : 0) + (keyBuffer != null ? keyBuffer.capacity() : 0) + (valueBuffer != null ? valueBuffer.capacity() : 0);
                ChannelBuffer corkedResponse = this.cork(command.cmd.opaque, totalCapacity);
                corkedResponse.writeBytes(headerBuffer);
                if (extrasBuffer != null) {
                    corkedResponse.writeBytes(extrasBuffer);
                }
                if (keyBuffer != null) {
                    corkedResponse.writeBytes(keyBuffer);
                }
                if (valueBuffer != null) {
                    corkedResponse.writeBytes(valueBuffer);
                }
            } else {
                if (this.corkedBuffers.containsKey(command.cmd.opaque)) {
                    this.uncork(command.cmd.opaque, messageEvent.getChannel());
                }
                this.writePayload(messageEvent, extrasBuffer, keyBuffer, valueBuffer, headerBuffer);
            }
        }
    }

    private ChannelBuffer cork(int opaque, int totalCapacity) {
        if (this.corkedBuffers.containsKey(opaque)) {
            ChannelBuffer corkedResponse;
            ChannelBuffer oldBuffer = corkedResponse = this.corkedBuffers.get(opaque);
            corkedResponse = ChannelBuffers.buffer((ByteOrder)ByteOrder.BIG_ENDIAN, (int)(totalCapacity + corkedResponse.capacity()));
            corkedResponse.writeBytes(oldBuffer);
            oldBuffer.clear();
            this.corkedBuffers.remove(opaque);
            this.corkedBuffers.put(opaque, corkedResponse);
            return corkedResponse;
        }
        ChannelBuffer buffer = ChannelBuffers.buffer((ByteOrder)ByteOrder.BIG_ENDIAN, (int)totalCapacity);
        this.corkedBuffers.put(opaque, buffer);
        return buffer;
    }

    private void uncork(int opaque, Channel channel) {
        ChannelBuffer corkedBuffer = this.corkedBuffers.get(opaque);
        assert (corkedBuffer != null);
        channel.write((Object)corkedBuffer);
        this.corkedBuffers.remove(opaque);
    }

    private void writePayload(MessageEvent messageEvent, ChannelBuffer extrasBuffer, ChannelBuffer keyBuffer, ChannelBuffer valueBuffer, ChannelBuffer headerBuffer) {
        if (messageEvent.getChannel().isOpen()) {
            messageEvent.getChannel().write((Object)headerBuffer);
            if (extrasBuffer != null) {
                messageEvent.getChannel().write((Object)extrasBuffer);
            }
            if (keyBuffer != null) {
                messageEvent.getChannel().write((Object)keyBuffer);
            }
            if (valueBuffer != null) {
                messageEvent.getChannel().write((Object)valueBuffer);
            }
        }
    }

    public static enum ResponseCode {
        OK(0),
        KEYNF(1),
        KEYEXISTS(2),
        TOOLARGE(3),
        INVARG(4),
        NOT_STORED(5),
        UNKNOWN(129),
        OOM(130);

        private final short code;

        private ResponseCode(int code) {
            this.code = (short)code;
        }

        public short getCode() {
            return this.code;
        }
    }
}

