/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.memcached.protocol.text;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.openspaces.memcached.Key;
import org.openspaces.memcached.LocalCacheElement;
import org.openspaces.memcached.protocol.CommandMessage;
import org.openspaces.memcached.protocol.Op;
import org.openspaces.memcached.protocol.SessionStatus;
import org.openspaces.memcached.protocol.exceptions.InvalidProtocolStateException;
import org.openspaces.memcached.protocol.exceptions.MalformedCommandException;
import org.openspaces.memcached.protocol.exceptions.UnknownCommandException;
import org.openspaces.memcached.util.BufferUtils;

public final class MemcachedCommandDecoder
extends SimpleChannelUpstreamHandler {
    private SessionStatus status;
    private static final byte[] NOREPLY = "noreply".getBytes();

    public MemcachedCommandDecoder(SessionStatus status) {
        this.status = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext channelHandlerContext, MessageEvent messageEvent) throws Exception {
        block7: {
            ChannelBuffer in = (ChannelBuffer)messageEvent.getMessage();
            try {
                if (this.status.state == SessionStatus.State.PROCESSING) {
                    ArrayList<byte[]> pieces = new ArrayList<byte[]>(6);
                    int pos = in.bytesBefore((byte)32);
                    do {
                        if (pos == -1) continue;
                        byte[] piece = new byte[pos];
                        in.readBytes(piece);
                        pieces.add(piece);
                        in.skipBytes(1);
                    } while ((pos = in.bytesBefore((byte)32)) != -1);
                    byte[] remainder = new byte[in.readableBytes()];
                    in.readBytes(remainder);
                    pieces.add(remainder);
                    this.processLine(pieces, messageEvent.getChannel(), channelHandlerContext);
                    break block7;
                }
                if (this.status.state == SessionStatus.State.PROCESSING_MULTILINE) {
                    ChannelBuffer slice = in.copy();
                    byte[] payload = slice.array();
                    in.skipBytes(in.readableBytes());
                    this.continueSet(messageEvent.getChannel(), this.status, payload, channelHandlerContext);
                    break block7;
                }
                throw new InvalidProtocolStateException("invalid protocol state");
            }
            finally {
                if (this.status.state != SessionStatus.State.WAITING_FOR_DATA) {
                    this.status.ready();
                }
            }
        }
    }

    private void processLine(List<byte[]> parts, Channel channel, ChannelHandlerContext channelHandlerContext) throws UnknownCommandException, MalformedCommandException {
        Op op;
        int numParts = parts.size();
        try {
            op = Op.findOp(parts.get(0));
        }
        catch (IllegalArgumentException e) {
            throw new UnknownCommandException("unknown operation: " + new String(parts.get(0)));
        }
        CommandMessage cmd = CommandMessage.command(op);
        switch (op) {
            case DELETE: {
                if (numParts < 2 || numParts > 4) {
                    throw new MalformedCommandException("invalid delete command");
                }
                cmd.setKey(parts.get(1));
                if (numParts > 2) {
                    if (Arrays.equals(parts.get(numParts - 1), NOREPLY)) {
                        cmd.noreply = true;
                        if (numParts == 4) {
                            cmd.time = BufferUtils.atoi(parts.get(2));
                        }
                    } else if (numParts == 3) {
                        cmd.time = BufferUtils.atoi(parts.get(2));
                    } else {
                        throw new MalformedCommandException("invalid delete command");
                    }
                }
                Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)cmd, (SocketAddress)channel.getRemoteAddress());
                break;
            }
            case DECR: 
            case INCR: {
                if (numParts < 3 || numParts > 4) {
                    throw new MalformedCommandException("invalid incr/decr command");
                }
                cmd.setKey(parts.get(1));
                cmd.incrAmount = BufferUtils.atoi(parts.get(2));
                if (numParts == 4 && Arrays.equals(parts.get(3), NOREPLY)) {
                    cmd.noreply = true;
                }
                Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)cmd, (SocketAddress)channel.getRemoteAddress());
                break;
            }
            case FLUSH_ALL: {
                if (numParts >= 1) {
                    if (Arrays.equals(parts.get(numParts - 1), NOREPLY)) {
                        cmd.noreply = true;
                        if (numParts == 3) {
                            cmd.time = BufferUtils.atoi(parts.get(1));
                        }
                    } else if (numParts == 2) {
                        cmd.time = BufferUtils.atoi(parts.get(1));
                    }
                }
                Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)cmd, (SocketAddress)channel.getRemoteAddress());
                break;
            }
            case VERBOSITY: {
                if (numParts < 2 || numParts > 3) {
                    throw new MalformedCommandException("invalid verbosity command");
                }
                cmd.time = BufferUtils.atoi(parts.get(1));
                if (numParts > 1 && Arrays.equals(parts.get(2), NOREPLY)) {
                    cmd.noreply = true;
                }
                Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)cmd, (SocketAddress)channel.getRemoteAddress());
                break;
            }
            case APPEND: 
            case PREPEND: 
            case REPLACE: 
            case ADD: 
            case SET: 
            case CAS: {
                if (numParts < 5) {
                    throw new MalformedCommandException("invalid command length");
                }
                int size = BufferUtils.atoi(parts.get(4));
                int expire = BufferUtils.atoi(parts.get(3));
                int flags = BufferUtils.atoi(parts.get(2));
                if (expire == 0) {
                    expire = Integer.MAX_VALUE;
                } else if (expire > 2592000) {
                    expire = LocalCacheElement.Now() - expire;
                }
                cmd.element = new LocalCacheElement(new Key(parts.get(1)), flags, expire, 0L);
                if (numParts > 5) {
                    int noreply;
                    int n = noreply = op == Op.CAS ? 6 : 5;
                    if (op == Op.CAS) {
                        cmd.cas_key = BufferUtils.atol(parts.get(5));
                    }
                    if (numParts == noreply + 1 && Arrays.equals(parts.get(noreply), NOREPLY)) {
                        cmd.noreply = true;
                    }
                }
                this.status.needMore(size, cmd);
                break;
            }
            case GET: 
            case GETS: 
            case STATS: {
                cmd.setKeys(parts.subList(1, numParts));
                Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)cmd, (SocketAddress)channel.getRemoteAddress());
                break;
            }
            case VERSION: 
            case QUIT: {
                if (numParts > 1) {
                    throw new MalformedCommandException("invalid command length");
                }
                Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)cmd, (SocketAddress)channel.getRemoteAddress());
                break;
            }
            default: {
                throw new UnknownCommandException("unknown command: " + (Object)((Object)op));
            }
        }
    }

    private void continueSet(Channel channel, SessionStatus state, byte[] remainder, ChannelHandlerContext channelHandlerContext) {
        state.cmd.element.setData(remainder);
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)state.cmd, (SocketAddress)channelHandlerContext.getChannel().getRemoteAddress());
    }
}

