/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.memcached.protocol.text;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferIndexFinder;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.openspaces.memcached.protocol.SessionStatus;
import org.openspaces.memcached.protocol.exceptions.IncorrectlyTerminatedPayloadException;
import org.openspaces.memcached.protocol.text.MemcachedResponseEncoder;

public final class MemcachedFrameDecoder
extends FrameDecoder {
    private final SessionStatus status;
    private final int maxFrameLength;
    private boolean discardingTooLongFrame;
    private long tooLongFrameLength;

    public MemcachedFrameDecoder(SessionStatus status, int maxFrameLength) {
        this.status = status;
        MemcachedFrameDecoder.validateMaxFrameLength(maxFrameLength);
        this.maxFrameLength = maxFrameLength;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (this.status.state == SessionStatus.State.WAITING_FOR_DATA) {
            if (buffer.readableBytes() < this.status.bytesNeeded + MemcachedResponseEncoder.CRLF.capacity()) {
                return null;
            }
            ChannelBuffer dest = buffer.slice(this.status.bytesNeeded + buffer.readerIndex(), 2);
            if (!dest.equals((Object)MemcachedResponseEncoder.CRLF)) {
                this.status.ready();
                throw new IncorrectlyTerminatedPayloadException("payload not terminated correctly");
            }
            this.status.processingMultiline();
            ChannelBuffer result = buffer.slice(buffer.readerIndex(), this.status.bytesNeeded);
            buffer.skipBytes(this.status.bytesNeeded + MemcachedResponseEncoder.CRLF.capacity());
            return result;
        }
        int minFrameLength = Integer.MAX_VALUE;
        ChannelBuffer foundDelimiter = null;
        int frameLength = buffer.bytesBefore(ChannelBufferIndexFinder.CRLF);
        if (frameLength >= 0 && frameLength < minFrameLength) {
            minFrameLength = frameLength;
            foundDelimiter = MemcachedResponseEncoder.CRLF;
        }
        if (foundDelimiter != null) {
            int minDelimLength = foundDelimiter.capacity();
            if (this.discardingTooLongFrame) {
                long tooLongFrameLength = this.tooLongFrameLength;
                this.tooLongFrameLength = 0L;
                this.discardingTooLongFrame = false;
                buffer.skipBytes(minFrameLength + minDelimLength);
                this.fail(tooLongFrameLength + (long)minFrameLength + (long)minDelimLength);
            }
            if (minFrameLength > this.maxFrameLength) {
                buffer.skipBytes(minFrameLength + minDelimLength);
                this.fail(minFrameLength);
            }
            ChannelBuffer frame = buffer.slice(buffer.readerIndex(), minFrameLength);
            buffer.skipBytes(minFrameLength + minDelimLength);
            this.status.processing();
            return frame;
        }
        if (buffer.readableBytes() > this.maxFrameLength) {
            this.tooLongFrameLength = buffer.readableBytes();
            buffer.skipBytes(buffer.readableBytes());
            this.discardingTooLongFrame = true;
        }
        return null;
    }

    private void fail(long frameLength) throws TooLongFrameException {
        throw new TooLongFrameException("The frame length exceeds " + this.maxFrameLength + ": " + frameLength);
    }

    private static void validateMaxFrameLength(int maxFrameLength) {
        if (maxFrameLength <= 0) {
            throw new IllegalArgumentException("maxFrameLength must be a positive integer: " + maxFrameLength);
        }
    }
}

