/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.memcached.protocol.text;

import java.nio.charset.Charset;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.openspaces.memcached.SpaceCache;
import org.openspaces.memcached.protocol.MemcachedCommandHandler;
import org.openspaces.memcached.protocol.SessionStatus;
import org.openspaces.memcached.protocol.text.MemcachedCommandDecoder;
import org.openspaces.memcached.protocol.text.MemcachedFrameDecoder;
import org.openspaces.memcached.protocol.text.MemcachedResponseEncoder;

public final class MemcachedPipelineFactory
implements ChannelPipelineFactory {
    public static final Charset USASCII = Charset.forName("US-ASCII");
    private SpaceCache cache;
    private String version;
    private boolean verbose;
    private int idleTime;
    private int frameSize;
    private DefaultChannelGroup channelGroup;
    private final MemcachedResponseEncoder memcachedResponseEncoder = new MemcachedResponseEncoder();
    private final MemcachedCommandHandler memcachedCommandHandler;

    public MemcachedPipelineFactory(SpaceCache cache, String version, boolean verbose, int idleTime, int frameSize, DefaultChannelGroup channelGroup) {
        this.cache = cache;
        this.version = version;
        this.verbose = verbose;
        this.idleTime = idleTime;
        this.frameSize = frameSize;
        this.channelGroup = channelGroup;
        this.memcachedCommandHandler = new MemcachedCommandHandler(this.cache, this.version, this.verbose, this.idleTime, this.channelGroup);
    }

    public final ChannelPipeline getPipeline() throws Exception {
        SessionStatus status = new SessionStatus().ready();
        return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new MemcachedFrameDecoder(status, this.frameSize), new MemcachedCommandDecoder(status), this.memcachedCommandHandler, this.memcachedResponseEncoder});
    }
}

