/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.memcached.protocol.text;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.openspaces.memcached.LocalCacheElement;
import org.openspaces.memcached.SpaceCache;
import org.openspaces.memcached.protocol.Op;
import org.openspaces.memcached.protocol.ResponseMessage;
import org.openspaces.memcached.protocol.exceptions.ClientException;
import org.openspaces.memcached.protocol.text.MemcachedPipelineFactory;
import org.openspaces.memcached.util.BufferUtils;

public final class MemcachedResponseEncoder
extends SimpleChannelUpstreamHandler {
    protected static final Log logger = LogFactory.getLog(MemcachedResponseEncoder.class);
    public static final ChannelBuffer CRLF = ChannelBuffers.copiedBuffer((CharSequence)"\r\n", (Charset)MemcachedPipelineFactory.USASCII);
    private static final ChannelBuffer VALUE = ChannelBuffers.copiedBuffer((CharSequence)"VALUE ", (Charset)MemcachedPipelineFactory.USASCII);
    private static final ChannelBuffer EXISTS = ChannelBuffers.copiedBuffer((CharSequence)"EXISTS\r\n", (Charset)MemcachedPipelineFactory.USASCII);
    private static final ChannelBuffer NOT_FOUND = ChannelBuffers.copiedBuffer((CharSequence)"NOT_FOUND\r\n", (Charset)MemcachedPipelineFactory.USASCII);
    private static final ChannelBuffer NOT_STORED = ChannelBuffers.copiedBuffer((CharSequence)"NOT_STORED\r\n", (Charset)MemcachedPipelineFactory.USASCII);
    private static final ChannelBuffer STORED = ChannelBuffers.copiedBuffer((CharSequence)"STORED\r\n", (Charset)MemcachedPipelineFactory.USASCII);
    private static final ChannelBuffer DELETED = ChannelBuffers.copiedBuffer((CharSequence)"DELETED\r\n", (Charset)MemcachedPipelineFactory.USASCII);
    private static final ChannelBuffer END = ChannelBuffers.copiedBuffer((CharSequence)"END\r\n", (Charset)MemcachedPipelineFactory.USASCII);
    private static final ChannelBuffer OK = ChannelBuffers.copiedBuffer((CharSequence)"OK\r\n", (Charset)MemcachedPipelineFactory.USASCII);
    private static final ChannelBuffer ERROR = ChannelBuffers.copiedBuffer((CharSequence)"ERROR\r\n", (Charset)MemcachedPipelineFactory.USASCII);
    private static final ChannelBuffer CLIENT_ERROR = ChannelBuffers.copiedBuffer((CharSequence)"CLIENT_ERROR\r\n", (Charset)MemcachedPipelineFactory.USASCII);

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        block4: {
            try {
                throw e.getCause();
            }
            catch (ClientException ce) {
                if (ctx.getChannel().isOpen()) {
                    ctx.getChannel().write((Object)CLIENT_ERROR);
                }
            }
            catch (Throwable tr) {
                logger.error((Object)"error", tr);
                if (!ctx.getChannel().isOpen()) break block4;
                ctx.getChannel().write((Object)ERROR);
            }
        }
    }

    public void messageReceived(ChannelHandlerContext channelHandlerContext, MessageEvent messageEvent) throws Exception {
        ResponseMessage command = (ResponseMessage)messageEvent.getMessage();
        Channel channel = messageEvent.getChannel();
        Op cmd = command.cmd.op;
        switch (cmd) {
            case GET: 
            case GETS: {
                LocalCacheElement[] results = command.elements;
                int totalBytes = 0;
                for (LocalCacheElement result : results) {
                    if (result == null) continue;
                    totalBytes += result.size() + 512;
                }
                ChannelBuffer writeBuffer = ChannelBuffers.dynamicBuffer((int)totalBytes);
                for (LocalCacheElement result : results) {
                    if (result == null) continue;
                    writeBuffer.writeBytes(VALUE.duplicate());
                    writeBuffer.writeBytes(result.getKey().bytes);
                    writeBuffer.writeByte(32);
                    writeBuffer.writeBytes(BufferUtils.itoa(result.getFlags()));
                    writeBuffer.writeByte(32);
                    writeBuffer.writeBytes(BufferUtils.itoa(result.getData().length));
                    if (cmd == Op.GETS) {
                        writeBuffer.writeByte(32);
                        writeBuffer.writeBytes(BufferUtils.ltoa(result.getCasUnique()));
                    }
                    writeBuffer.writeByte(13);
                    writeBuffer.writeByte(10);
                    writeBuffer.writeBytes(result.getData());
                    writeBuffer.writeByte(13);
                    writeBuffer.writeByte(10);
                }
                writeBuffer.writeBytes(END.duplicate());
                Channels.write((Channel)channel, (Object)writeBuffer);
                break;
            }
            case SET: 
            case CAS: 
            case ADD: 
            case REPLACE: 
            case APPEND: 
            case PREPEND: {
                if (command.cmd.noreply) break;
                Channels.write((Channel)channel, (Object)this.storeResponse(command.response));
                break;
            }
            case INCR: 
            case DECR: {
                if (command.cmd.noreply) break;
                Channels.write((Channel)channel, (Object)this.incrDecrResponseString(command.incrDecrResponse));
                break;
            }
            case DELETE: {
                if (command.cmd.noreply) break;
                Channels.write((Channel)channel, (Object)this.deleteResponseString(command.deleteResponse));
                break;
            }
            case STATS: {
                for (Map.Entry<String, Set<String>> stat : command.stats.entrySet()) {
                    for (String statVal : stat.getValue()) {
                        StringBuilder builder = new StringBuilder();
                        builder.append("STAT ");
                        builder.append(stat.getKey());
                        builder.append(" ");
                        builder.append(String.valueOf(statVal));
                        builder.append("\r\n");
                        Channels.write((Channel)channel, (Object)ChannelBuffers.copiedBuffer((CharSequence)builder.toString(), (Charset)MemcachedPipelineFactory.USASCII));
                    }
                }
                Channels.write((Channel)channel, (Object)END.duplicate());
                break;
            }
            case VERSION: {
                Channels.write((Channel)channel, (Object)ChannelBuffers.copiedBuffer((CharSequence)("VERSION " + command.version + "\r\n"), (Charset)MemcachedPipelineFactory.USASCII));
                break;
            }
            case QUIT: {
                Channels.disconnect((Channel)channel);
                break;
            }
            case FLUSH_ALL: {
                if (command.cmd.noreply) break;
                ChannelBuffer ret = command.flushSuccess ? OK.duplicate() : ERROR.duplicate();
                Channels.write((Channel)channel, (Object)ret);
                break;
            }
            default: {
                Channels.write((Channel)channel, (Object)ERROR.duplicate());
                logger.error((Object)("error; unrecognized command: " + (Object)((Object)cmd)));
            }
        }
    }

    private ChannelBuffer deleteResponseString(SpaceCache.DeleteResponse deleteResponse) {
        if (deleteResponse == SpaceCache.DeleteResponse.DELETED) {
            return DELETED.duplicate();
        }
        return NOT_FOUND.duplicate();
    }

    private ChannelBuffer incrDecrResponseString(Integer ret) {
        if (ret == null) {
            return NOT_FOUND.duplicate();
        }
        return ChannelBuffers.copiedBuffer((CharSequence)(String.valueOf(ret) + "\r\n"), (Charset)MemcachedPipelineFactory.USASCII);
    }

    private ChannelBuffer storeResponse(SpaceCache.StoreResponse storeResponse) {
        switch (storeResponse) {
            case EXISTS: {
                return EXISTS.duplicate();
            }
            case NOT_FOUND: {
                return NOT_FOUND.duplicate();
            }
            case NOT_STORED: {
                return NOT_STORED.duplicate();
            }
            case STORED: {
                return STORED.duplicate();
            }
        }
        throw new RuntimeException("unknown store response from cache: " + (Object)((Object)storeResponse));
    }
}

