/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency;

import com.gigaspaces.annotation.pojo.SpaceClass;
import com.gigaspaces.annotation.pojo.SpaceInitialLoadQuery;
import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.datasource.SpaceDataSource;
import com.gigaspaces.internal.utils.ReflectionUtils;
import com.gigaspaces.metadata.SpacePropertyDescriptor;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.cluster.ClusterInfoAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.TypeFilter;

public abstract class ClusterInfoAwareSpaceDataSource
extends SpaceDataSource
implements ClusterInfoAware {
    protected String[] initialLoadQueryScanningBasePackages = null;
    protected ClusterInfo clusterInfo;
    protected Map<String, String> initialLoadQueries = new HashMap<String, String>();
    protected boolean augmentInitialLoadEntries = true;

    public void setInitialLoadQueryScanningBasePackages(String[] initialLoadQueryScanningBasePackages) {
        this.initialLoadQueryScanningBasePackages = initialLoadQueryScanningBasePackages;
    }

    public DataIterator<SpaceTypeDescriptor> initialMetadataLoad() {
        this.initialLoadQueries.clear();
        return super.initialMetadataLoad();
    }

    @Override
    public void setClusterInfo(ClusterInfo clusterInfo) {
        this.clusterInfo = clusterInfo;
    }

    public Map<String, String> getInitialLoadQueries() {
        return this.initialLoadQueries;
    }

    private boolean isClassMatch(MetadataReader metadataReader, ClassLoader classLoader) {
        Class<?> clazz;
        try {
            clazz = classLoader.loadClass(metadataReader.getClassMetadata().getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Classpath scanning error", e);
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(SpaceInitialLoadQuery.class)) continue;
            return true;
        }
        return false;
    }

    protected void obtainInitialLoadQueries() {
        final ClassLoader classLoader = new ClassLoader(this.getClass().getClassLoader()){};
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter(new TypeFilter(){

            public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
                return ClusterInfoAwareSpaceDataSource.this.isClassMatch(metadataReader, classLoader);
            }
        });
        if (this.initialLoadQueryScanningBasePackages == null) {
            return;
        }
        for (String basePackage : this.initialLoadQueryScanningBasePackages) {
            Set candidates = scanner.findCandidateComponents(basePackage);
            for (BeanDefinition beanDefinition : candidates) {
                Class<?> clazz;
                try {
                    clazz = classLoader.loadClass(beanDefinition.getBeanClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Cannot access class " + beanDefinition.getBeanClassName(), e);
                }
                ReflectionUtils.doWithMethods(clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                    public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                        ClusterInfoAwareSpaceDataSource.this.processMethod(method, clazz);
                    }
                }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

                    public boolean matches(Method method) {
                        return method.isAnnotationPresent(SpaceInitialLoadQuery.class);
                    }
                });
            }
        }
    }

    private void processMethod(Method method, Class<?> clazz) {
        String query;
        String type = this.processMethodAnnotation(method, clazz);
        boolean requiresClusterInfo = false;
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length > 0) {
            if (paramTypes.length == 1 && paramTypes[0].equals(ClusterInfo.class)) {
                requiresClusterInfo = true;
            } else {
                throw new IllegalStateException("Initial load query method receives unexpected parameters (expected none or ClusterInfo only) - " + method);
            }
        }
        Object obj = null;
        if (!Modifier.isStatic(method.getModifiers())) {
            try {
                obj = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Class " + clazz.getName() + " has no public zero-parameter constructor! Cannot invoke initial load query method " + method.getName());
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Class " + clazz.getName() + " has no public zero-parameter constructor! Cannot invoke initial load query method " + method.getName());
            }
        }
        try {
            query = requiresClusterInfo ? (String)method.invoke(obj, this.clusterInfo) : (String)method.invoke(obj, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Initial load query method has thrown an exception: " + method, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot invoke initial load query method because it is not public: " + method, e);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Initial load query method returns unexpected type (expected String) - " + method);
        }
        this.initialLoadQueries.put(type, query);
    }

    private String processMethodAnnotation(Method method, Class<?> clazz) {
        SpaceInitialLoadQuery queryAnnotation = method.getAnnotation(SpaceInitialLoadQuery.class);
        String type = queryAnnotation.type();
        if (type == null || type.isEmpty()) {
            if (!clazz.isAnnotationPresent(SpaceClass.class)) {
                throw new IllegalStateException(SpaceInitialLoadQuery.class.getName() + " annotation without 'type' argument appears in class " + clazz.getName() + " which is not annotated as " + SpaceClass.class.getName());
            }
            type = clazz.getName();
        }
        if (this.initialLoadQueries.containsKey(type)) {
            throw new IllegalArgumentException("There is more than one initial load query for type " + type);
        }
        return type;
    }

    protected String createInitialLoadQuery(SpaceTypeDescriptor typeDescriptor, String templateQuery) {
        SpacePropertyDescriptor routingPropertyType = typeDescriptor.getFixedProperty(typeDescriptor.getRoutingPropertyName());
        if (routingPropertyType == null) {
            return null;
        }
        Class routingPropertyClass = routingPropertyType.getType();
        if (!ReflectionUtils.isNumeric((Class)routingPropertyClass)) {
            return null;
        }
        return templateQuery.replace("?", routingPropertyType.getName());
    }
}

