/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.patterns;

import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.datasource.DataSourceIdQuery;
import com.gigaspaces.datasource.DataSourceIdsQuery;
import com.gigaspaces.datasource.DataSourceQuery;
import com.gigaspaces.datasource.SpaceDataSource;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import org.openspaces.persistency.patterns.PersistencyExceptionHandler;

public class SpaceDataSourceExceptionHandler
extends SpaceDataSource {
    private final SpaceDataSource dataSource;
    private final PersistencyExceptionHandler exceptionHandler;

    public SpaceDataSourceExceptionHandler(SpaceDataSource dataSource, PersistencyExceptionHandler exceptionHandler) {
        this.dataSource = dataSource;
        this.exceptionHandler = exceptionHandler;
    }

    public DataIterator<Object> initialDataLoad() {
        return this.dataSource.initialDataLoad();
    }

    public DataIterator<SpaceTypeDescriptor> initialMetadataLoad() {
        return this.dataSource.initialMetadataLoad();
    }

    public DataIterator<Object> getDataIterator(DataSourceQuery query) {
        try {
            return this.dataSource.getDataIterator(query);
        }
        catch (Exception e) {
            this.exceptionHandler.onException(e, query);
            return null;
        }
    }

    public Object getById(DataSourceIdQuery idQuery) {
        try {
            return this.dataSource.getById(idQuery);
        }
        catch (Exception e) {
            this.exceptionHandler.onException(e, idQuery);
            return null;
        }
    }

    public DataIterator<Object> getDataIteratorByIds(DataSourceIdsQuery idsQuery) {
        try {
            return this.dataSource.getDataIteratorByIds(idsQuery);
        }
        catch (Exception e) {
            this.exceptionHandler.onException(e, idsQuery);
            return null;
        }
    }

    public boolean supportsInheritance() {
        return this.dataSource.supportsInheritance();
    }
}

