/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.patterns;

import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.datasource.DataSourceIdQuery;
import com.gigaspaces.datasource.DataSourceIdsQuery;
import com.gigaspaces.datasource.DataSourceQuery;
import com.gigaspaces.datasource.SpaceDataSource;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openspaces.persistency.patterns.ManagedEntriesSpaceDataSource;
import org.openspaces.persistency.support.ConcurrentMultiDataIterator;
import org.openspaces.persistency.support.SerialMultiDataIterator;

public class SpaceDataSourceSplitter
extends SpaceDataSource {
    private final ManagedEntriesSpaceDataSource[] dataSources;
    private final Map<String, SpaceDataSource> entriesToDataSource = new HashMap<String, SpaceDataSource>();
    private int initalLoadThreadPoolSize = 10;

    public SpaceDataSourceSplitter(ManagedEntriesSpaceDataSource[] dataSources) {
        this.dataSources = dataSources;
        for (ManagedEntriesSpaceDataSource dataSource : dataSources) {
            for (String entry : dataSource.getManagedEntries()) {
                this.entriesToDataSource.put(entry, dataSource);
            }
        }
    }

    public void setInitalLoadThreadPoolSize(int initalLoadThreadPoolSize) {
        this.initalLoadThreadPoolSize = initalLoadThreadPoolSize;
    }

    protected SpaceDataSource getDataSource(String entry) {
        return this.entriesToDataSource.get(entry);
    }

    public DataIterator<Object> initialDataLoad() {
        ArrayList<DataIterator> iterators = new ArrayList<DataIterator>(this.dataSources.length);
        for (ManagedEntriesSpaceDataSource dataSource : this.dataSources) {
            DataIterator iterator = dataSource.initialDataLoad();
            if (iterator == null) continue;
            iterators.add(iterator);
        }
        return new ConcurrentMultiDataIterator(iterators.toArray(new DataIterator[iterators.size()]), this.initalLoadThreadPoolSize);
    }

    public DataIterator<SpaceTypeDescriptor> initialMetadataLoad() {
        ArrayList<DataIterator> iterators = new ArrayList<DataIterator>(this.dataSources.length);
        for (ManagedEntriesSpaceDataSource dataSource : this.dataSources) {
            DataIterator iterator = dataSource.initialMetadataLoad();
            if (iterator == null) continue;
            iterators.add(iterator);
        }
        return new SerialMultiDataIterator(iterators.toArray(new DataIterator[iterators.size()]));
    }

    public DataIterator<Object> getDataIterator(DataSourceQuery query) {
        SpaceDataSource dataSource = this.getDataSource(query.getTypeDescriptor().getTypeName());
        return dataSource == null ? null : dataSource.getDataIterator(query);
    }

    public Object getById(DataSourceIdQuery idQuery) {
        SpaceDataSource dataSource = this.getDataSource(idQuery.getTypeDescriptor().getTypeName());
        return dataSource == null ? null : dataSource.getById(idQuery);
    }

    public DataIterator<Object> getDataIteratorByIds(DataSourceIdsQuery idsQuery) {
        SpaceDataSource dataSource = this.getDataSource(idsQuery.getTypeDescriptor().getTypeName());
        return dataSource == null ? null : dataSource.getDataIteratorByIds(idsQuery);
    }
}

