/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.patterns;

import com.gigaspaces.sync.AddIndexData;
import com.gigaspaces.sync.ConsolidationParticipantData;
import com.gigaspaces.sync.IntroduceTypeData;
import com.gigaspaces.sync.OperationsBatchData;
import com.gigaspaces.sync.SpaceSynchronizationEndpoint;
import com.gigaspaces.sync.TransactionData;
import org.openspaces.persistency.patterns.PersistencyExceptionHandler;

public class SpaceSynchronizationEndpointExceptionHandler
extends SpaceSynchronizationEndpoint {
    private final SpaceSynchronizationEndpoint interceptor;
    private final PersistencyExceptionHandler exceptionHandler;

    public SpaceSynchronizationEndpointExceptionHandler(SpaceSynchronizationEndpoint interceptor, PersistencyExceptionHandler exceptionHandler) {
        this.interceptor = interceptor;
        this.exceptionHandler = exceptionHandler;
    }

    public void onTransactionConsolidationFailure(ConsolidationParticipantData participantData) {
        this.interceptor.onTransactionConsolidationFailure(participantData);
    }

    public void onTransactionSynchronization(TransactionData transactionData) {
        try {
            this.interceptor.onTransactionSynchronization(transactionData);
        }
        catch (Exception e) {
            this.exceptionHandler.onException(e, transactionData);
        }
    }

    public void afterTransactionSynchronization(TransactionData transactionData) {
        this.interceptor.afterTransactionSynchronization(transactionData);
    }

    public void onOperationsBatchSynchronization(OperationsBatchData batchData) {
        try {
            this.interceptor.onOperationsBatchSynchronization(batchData);
        }
        catch (Exception e) {
            this.exceptionHandler.onException(e, batchData);
        }
    }

    public void afterOperationsBatchSynchronization(OperationsBatchData batchData) {
        this.interceptor.afterOperationsBatchSynchronization(batchData);
    }

    public void onAddIndex(AddIndexData addIndexData) {
        try {
            this.interceptor.onAddIndex(addIndexData);
        }
        catch (Exception e) {
            this.exceptionHandler.onException(e, addIndexData);
        }
    }

    public void onIntroduceType(IntroduceTypeData introduceTypeData) {
        try {
            this.interceptor.onIntroduceType(introduceTypeData);
        }
        catch (Exception e) {
            this.exceptionHandler.onException(e, introduceTypeData);
        }
    }
}

