/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.patterns;

import com.gigaspaces.sync.AddIndexData;
import com.gigaspaces.sync.DataSyncOperation;
import com.gigaspaces.sync.IntroduceTypeData;
import com.gigaspaces.sync.OperationsBatchData;
import com.gigaspaces.sync.SpaceSynchronizationEndpoint;
import com.gigaspaces.sync.SynchronizationSourceDetails;
import com.gigaspaces.sync.TransactionData;
import com.gigaspaces.transaction.ConsolidatedDistributedTransactionMetaData;
import com.gigaspaces.transaction.TransactionParticipantMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspaces.persistency.patterns.ManagedEntriesSpaceSynchronizationEndpoint;

public class SpaceSynchronizationEndpointSplitter
extends SpaceSynchronizationEndpoint {
    private Map<String, SpaceSynchronizationEndpoint> entriesToSyncEndpoint = new HashMap<String, SpaceSynchronizationEndpoint>();

    public SpaceSynchronizationEndpointSplitter(ManagedEntriesSpaceSynchronizationEndpoint[] dataSources) {
        for (ManagedEntriesSpaceSynchronizationEndpoint dataSource : dataSources) {
            for (String entry : dataSource.getManagedEntries()) {
                this.entriesToSyncEndpoint.put(entry, dataSource);
            }
        }
    }

    protected SpaceSynchronizationEndpoint getEndpoint(String entry) {
        return this.entriesToSyncEndpoint.get(entry);
    }

    public void onOperationsBatchSynchronization(OperationsBatchData batchData) {
        DataSyncOperation[] operations = batchData.getBatchDataItems();
        Map<SpaceSynchronizationEndpoint, List<DataSyncOperation>> splitBatchDataMap = this.splitOperations(operations);
        for (Map.Entry<SpaceSynchronizationEndpoint, List<DataSyncOperation>> splitElement : splitBatchDataMap.entrySet()) {
            splitElement.getKey().onOperationsBatchSynchronization(this.wrapSplitAsOperationsBatchData(batchData, splitElement));
        }
    }

    public void afterOperationsBatchSynchronization(OperationsBatchData batchData) {
        DataSyncOperation[] operations = batchData.getBatchDataItems();
        Map<SpaceSynchronizationEndpoint, List<DataSyncOperation>> splitBatchDataMap = this.splitOperations(operations);
        for (Map.Entry<SpaceSynchronizationEndpoint, List<DataSyncOperation>> splitElement : splitBatchDataMap.entrySet()) {
            splitElement.getKey().afterOperationsBatchSynchronization(this.wrapSplitAsOperationsBatchData(batchData, splitElement));
        }
    }

    public void onTransactionSynchronization(TransactionData transactionData) {
        DataSyncOperation[] operations = transactionData.getTransactionParticipantDataItems();
        Map<SpaceSynchronizationEndpoint, List<DataSyncOperation>> splitBatchDataMap = this.splitOperations(operations);
        for (Map.Entry<SpaceSynchronizationEndpoint, List<DataSyncOperation>> splitElement : splitBatchDataMap.entrySet()) {
            splitElement.getKey().onTransactionSynchronization(this.wrapSplitAsTransactionData(transactionData, splitElement));
        }
    }

    public void afterTransactionSynchronization(TransactionData transactionData) {
        DataSyncOperation[] operations = transactionData.getTransactionParticipantDataItems();
        Map<SpaceSynchronizationEndpoint, List<DataSyncOperation>> splitBatchDataMap = this.splitOperations(operations);
        for (Map.Entry<SpaceSynchronizationEndpoint, List<DataSyncOperation>> splitElement : splitBatchDataMap.entrySet()) {
            splitElement.getKey().afterTransactionSynchronization(this.wrapSplitAsTransactionData(transactionData, splitElement));
        }
    }

    public void onAddIndex(AddIndexData addIndexData) {
        SpaceSynchronizationEndpoint endpointInterceptor = this.getEndpoint(addIndexData.getTypeName());
        if (endpointInterceptor != null) {
            endpointInterceptor.onAddIndex(addIndexData);
        }
    }

    public void onIntroduceType(IntroduceTypeData introduceTypeData) {
        SpaceSynchronizationEndpoint endpointInterceptor = this.getEndpoint(introduceTypeData.getTypeDescriptor().getTypeName());
        if (endpointInterceptor != null) {
            endpointInterceptor.onIntroduceType(introduceTypeData);
        }
    }

    private Map<SpaceSynchronizationEndpoint, List<DataSyncOperation>> splitOperations(DataSyncOperation[] operations) {
        HashMap<SpaceSynchronizationEndpoint, List<DataSyncOperation>> splitBatchDataMap = new HashMap<SpaceSynchronizationEndpoint, List<DataSyncOperation>>();
        for (DataSyncOperation dataSyncOperation : operations) {
            SpaceSynchronizationEndpoint endpointInterceptor;
            if (!dataSyncOperation.supportsGetTypeDescriptor() || (endpointInterceptor = this.getEndpoint(dataSyncOperation.getTypeDescriptor().getTypeName())) == null) continue;
            ArrayList<DataSyncOperation> list = (ArrayList<DataSyncOperation>)splitBatchDataMap.get(endpointInterceptor);
            if (list == null) {
                list = new ArrayList<DataSyncOperation>();
                splitBatchDataMap.put(endpointInterceptor, list);
            }
            list.add(dataSyncOperation);
        }
        return splitBatchDataMap;
    }

    private OperationsBatchData wrapSplitAsOperationsBatchData(final OperationsBatchData batchData, final Map.Entry<SpaceSynchronizationEndpoint, List<DataSyncOperation>> splitElement) {
        return new OperationsBatchData(){

            public SynchronizationSourceDetails getSourceDetails() {
                return batchData.getSourceDetails();
            }

            public DataSyncOperation[] getBatchDataItems() {
                List operations = (List)splitElement.getValue();
                return operations.toArray(new DataSyncOperation[operations.size()]);
            }
        };
    }

    private TransactionData wrapSplitAsTransactionData(final TransactionData transactionData, final Map.Entry<SpaceSynchronizationEndpoint, List<DataSyncOperation>> splitElement) {
        return new TransactionData(){

            public boolean isConsolidated() {
                return transactionData.isConsolidated();
            }

            public TransactionParticipantMetaData getTransactionParticipantMetaData() {
                return transactionData.getTransactionParticipantMetaData();
            }

            public DataSyncOperation[] getTransactionParticipantDataItems() {
                List operations = (List)splitElement.getValue();
                return operations.toArray(new DataSyncOperation[operations.size()]);
            }

            public SynchronizationSourceDetails getSourceDetails() {
                return transactionData.getSourceDetails();
            }

            public ConsolidatedDistributedTransactionMetaData getConsolidatedDistributedTransactionMetaData() {
                return transactionData.getConsolidatedDistributedTransactionMetaData();
            }
        };
    }
}

