/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.support;

import com.gigaspaces.datasource.DataIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.openspaces.persistency.support.MultiDataIterator;

public class ConcurrentMultiDataIterator
implements MultiDataIterator {
    private volatile boolean closed = false;
    private final int threadPoolSize;
    private final DataIterator[] iterators;
    private final BlockingQueue queue;
    private final DataIteratorRunnable[] runnables;
    private final AtomicInteger finishedRunnables = new AtomicInteger();
    private Object current;
    private int checkForExceptionsCounter = 0;
    private ExecutorService executor;
    private volatile RuntimeException exception;

    public ConcurrentMultiDataIterator(DataIterator[] iterators, int threadPoolSize) {
        ArrayList<DataIterator> itList = new ArrayList<DataIterator>();
        for (DataIterator iterator : iterators) {
            if (iterator instanceof MultiDataIterator) {
                itList.addAll(Arrays.asList(((MultiDataIterator)iterator).iterators()));
                continue;
            }
            itList.add(iterator);
        }
        this.iterators = itList.toArray(new DataIterator[itList.size()]);
        this.threadPoolSize = threadPoolSize;
        this.queue = new LinkedBlockingQueue();
        this.runnables = new DataIteratorRunnable[this.iterators.length];
    }

    @Override
    public DataIterator[] iterators() {
        return this.iterators;
    }

    public boolean hasNext() {
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(this.threadPoolSize);
            for (int i = 0; i < this.iterators.length; ++i) {
                this.runnables[i] = new DataIteratorRunnable(this.iterators[i]);
                this.executor.execute(this.runnables[i]);
            }
        }
        if (this.current != null) {
            return true;
        }
        do {
            if (this.checkForExceptionsCounter++ > 100) {
                this.checkForExceptionsCounter = 0;
                this.checkForExceptions();
            }
            try {
                this.current = this.queue.poll(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.current == null) continue;
            return true;
        } while (this.finishedRunnables.get() != this.iterators.length);
        this.checkForExceptions();
        return false;
    }

    public Object next() {
        Object next = this.current;
        this.current = null;
        return next;
    }

    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (DataIteratorRunnable runnable : this.runnables) {
            runnable.stop();
        }
        this.executor.shutdownNow();
    }

    private void checkForExceptions() {
        if (this.exception != null) {
            this.close();
            throw this.exception;
        }
    }

    private class DataIteratorRunnable
    implements Runnable {
        private volatile boolean running = true;
        private final DataIterator iterator;

        private DataIteratorRunnable(DataIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public void run() {
            try {
                while (this.running && this.iterator.hasNext()) {
                    ConcurrentMultiDataIterator.this.queue.put(this.iterator.next());
                }
            }
            catch (InterruptedException e) {
                ConcurrentMultiDataIterator.this.exception = new RuntimeException(e);
            }
            catch (RuntimeException e) {
                ConcurrentMultiDataIterator.this.exception = e;
            }
            finally {
                ConcurrentMultiDataIterator.this.finishedRunnables.incrementAndGet();
                this.iterator.close();
            }
        }

        public void stop() {
            this.running = false;
        }
    }
}

