/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.support;

import com.gigaspaces.internal.reflection.IConstructor;
import com.gigaspaces.internal.reflection.IGetterMethod;
import com.gigaspaces.internal.reflection.ISetterMethod;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;

public class ProcedureCache {
    private final ConcurrentHashMap<Method, IGetterMethod<Object>> getters = new ConcurrentHashMap();
    private final ConcurrentHashMap<Method, ISetterMethod<Object>> setters = new ConcurrentHashMap();
    private final ConcurrentHashMap<Constructor<Object>, IConstructor<Object>> constructors = new ConcurrentHashMap();

    public IGetterMethod<Object> getterMethodFor(Method getterMethod) {
        try {
            IGetterMethod<Object> objectIGetterMethod = this.getters.get(getterMethod);
            if (objectIGetterMethod != null) {
                return objectIGetterMethod;
            }
            IGetterMethod<Object> possibleGetter = ReflectionUtil.createGetterMethod((Method)getterMethod);
            IGetterMethod<Object> currentGetter = this.getters.putIfAbsent(getterMethod, possibleGetter);
            return currentGetter == null ? possibleGetter : currentGetter;
        }
        catch (Exception e) {
            throw new IllegalStateException("Reflection factory failed unexpectedly", e);
        }
    }

    public ISetterMethod<Object> setterMethodFor(Method setterMethod) {
        try {
            ISetterMethod<Object> objectISetterMethod = this.setters.get(setterMethod);
            if (objectISetterMethod != null) {
                return objectISetterMethod;
            }
            ISetterMethod<Object> possibleSetter = ReflectionUtil.createSetterMethod((Method)setterMethod);
            ISetterMethod<Object> currentSetter = this.setters.putIfAbsent(setterMethod, possibleSetter);
            return currentSetter == null ? possibleSetter : currentSetter;
        }
        catch (Exception e) {
            throw new IllegalStateException("Reflection factory failed unexpectedly", e);
        }
    }

    public IConstructor<Object> constructorFor(Constructor<Object> constructor) {
        try {
            IConstructor<Object> objectIConstructor = this.constructors.get(constructor);
            if (objectIConstructor != null) {
                return objectIConstructor;
            }
            IConstructor<Object> possibleConst = ReflectionUtil.createCtor(constructor);
            IConstructor<Object> currentConst = this.constructors.putIfAbsent(constructor, possibleConst);
            return currentConst == null ? possibleConst : currentConst;
        }
        catch (Exception e) {
            throw new IllegalStateException("Reflection factory failed unexpectedly", e);
        }
    }
}

