/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.support;

import com.gigaspaces.datasource.DataIterator;
import org.openspaces.persistency.support.MultiDataIterator;

public class SerialMultiDataIterator
implements MultiDataIterator {
    private final DataIterator[] iterators;
    private int currentIterator;

    public SerialMultiDataIterator(DataIterator ... iterators) {
        this.iterators = iterators;
        this.currentIterator = 0;
    }

    @Override
    public DataIterator[] iterators() {
        return this.iterators;
    }

    public boolean hasNext() {
        while (this.currentIterator < this.iterators.length) {
            if (this.iterators[this.currentIterator].hasNext()) {
                return true;
            }
            ++this.currentIterator;
        }
        return false;
    }

    public Object next() {
        return this.iterators[this.currentIterator].next();
    }

    public void close() {
        for (DataIterator iterator : this.iterators) {
            iterator.close();
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("remove is not supported in multi iterator");
    }
}

