/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.support;

import com.gigaspaces.metadata.SpaceTypeDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openspaces.persistency.support.SpaceTypeDescriptorContainer;

public class TypeDescriptorUtils {
    public static List<SpaceTypeDescriptor> sort(Collection<SpaceTypeDescriptor> typeDescriptors) {
        TypeHierarchySorter sorter = new TypeHierarchySorter();
        HashMap<String, SpaceTypeDescriptor> typeDescriptorsMap = new HashMap<String, SpaceTypeDescriptor>();
        for (SpaceTypeDescriptor typeDescriptor : typeDescriptors) {
            if (null == typeDescriptor) continue;
            typeDescriptorsMap.put(typeDescriptor.getTypeName(), typeDescriptor);
            sorter.addTypeName(typeDescriptor.getTypeName(), typeDescriptor.getSuperTypeName());
        }
        Map allTypeNameNodes = sorter.nodes;
        TypeNameNode root = sorter.fixAndGetRoot();
        LinkedList<SpaceTypeDescriptor> result = new LinkedList<SpaceTypeDescriptor>();
        for (String typeName : root.children) {
            TypeDescriptorUtils.addSelfThenChildren(typeName, typeDescriptorsMap, allTypeNameNodes, result);
        }
        return result;
    }

    public static List<SpaceTypeDescriptor> sort(Map<String, SpaceTypeDescriptorContainer> typeDescriptorContainers) {
        HashSet<SpaceTypeDescriptor> typeDescriptors = new HashSet<SpaceTypeDescriptor>();
        for (SpaceTypeDescriptorContainer container : typeDescriptorContainers.values()) {
            typeDescriptors.add(container.getTypeDescriptor());
        }
        return TypeDescriptorUtils.sort(typeDescriptors);
    }

    private static void addSelfThenChildren(String typeName, Map<String, SpaceTypeDescriptor> typeDescriptors, Map<String, TypeNameNode> nodes, List<SpaceTypeDescriptor> result) {
        SpaceTypeDescriptor typeDescriptor = typeDescriptors.get(typeName);
        result.add(typeDescriptor);
        TypeNameNode typeNameNode = nodes.get(typeName);
        for (String childTypeName : typeNameNode.children) {
            TypeDescriptorUtils.addSelfThenChildren(childTypeName, typeDescriptors, nodes, result);
        }
    }

    private static class TypeHierarchySorter {
        private final TypeNameNode root = new TypeNameNode(Object.class.getName(), null);
        private final Map<String, TypeNameNode> nodes = new HashMap<String, TypeNameNode>();

        private TypeHierarchySorter() {
            this.nodes.put(this.root.typeName, this.root);
        }

        private void addTypeName(String typeName, String superTypeName) {
            TypeNameNode typeNameNode = this.nodes.get(typeName);
            TypeNameNode superTypeNameNode = this.nodes.get(superTypeName);
            if (typeNameNode == null) {
                typeNameNode = new TypeNameNode(typeName, superTypeName);
                this.nodes.put(typeName, typeNameNode);
            } else {
                typeNameNode.superTypeName = superTypeName;
            }
            if (superTypeNameNode == null) {
                superTypeNameNode = new TypeNameNode(superTypeName, Object.class.getName());
            }
            superTypeNameNode.children.add(typeName);
            this.nodes.put(superTypeName, superTypeNameNode);
        }

        private TypeNameNode fixAndGetRoot() {
            for (TypeNameNode typeNameNode : this.nodes.values()) {
                if (typeNameNode == this.root || !typeNameNode.superTypeName.equals(this.root.typeName)) continue;
                this.root.children.add(typeNameNode.typeName);
            }
            return this.root;
        }
    }

    private static class TypeNameNode {
        private final String typeName;
        private String superTypeName;
        private final Set<String> children = new HashSet<String>();

        private TypeNameNode(String typeName, String superTypeName) {
            this.typeName = typeName;
            this.superTypeName = superTypeName;
        }
    }
}

