/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.utils;

import com.gigaspaces.time.SystemTime;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hsqldb.Server;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.server.ServerConfiguration;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class HsqlServerBean
implements InitializingBean,
DisposableBean {
    private static final Log log = LogFactory.getLog(HsqlServerBean.class);
    private Properties serverProperties;
    private Server server;
    private DataSource dataSource;

    public Properties getServerProperties() {
        return this.serverProperties;
    }

    public void setServerProperties(Properties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void afterPropertiesSet() throws Exception {
        HsqlProperties configProps = new HsqlProperties(this.serverProperties);
        ServerConfiguration.translateDefaultDatabaseProperty((HsqlProperties)configProps);
        this.server = new Server();
        this.server.setRestartOnShutdown(false);
        this.server.setNoSystemExit(true);
        this.server.setProperties(configProps);
        log.info((Object)"HSQL Server Startup sequence initiated");
        this.server.start();
        String portMsg = "port " + this.server.getPort();
        log.info((Object)("HSQL Server listening on " + portMsg));
    }

    public void destroy() {
        log.info((Object)"HSQL Server Shutdown sequence initiated");
        if (this.dataSource != null) {
            Connection con = null;
            try {
                con = this.dataSource.getConnection();
                con.createStatement().execute("SHUTDOWN");
            }
            catch (SQLException e) {
                log.error((Object)("HSQL Server Shutdown failed: " + e.getMessage()));
            }
            finally {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Exception e) {}
            }
        } else {
            log.warn((Object)"HSQL ServerBean needs a dataSource property set to shutdown database safely.");
        }
        this.server.signalCloseAllServerConnections();
        int status = this.server.stop();
        long timeout = SystemTime.timeMillis() + 5000L;
        while (status != 16 && SystemTime.timeMillis() < timeout) {
            try {
                Thread.sleep(100L);
                status = this.server.getState();
            }
            catch (InterruptedException e) {
                log.error((Object)("Error while shutting down HSQL Server: " + e.getMessage()));
                break;
            }
        }
        if (status != 16) {
            log.warn((Object)"HSQL Server failed to shutdown properly.");
        } else {
            log.info((Object)"HSQL Server Shutdown completed");
        }
        this.server = null;
    }
}

