/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container;

import com.gigaspaces.metrics.BeanMetricManager;
import com.gigaspaces.metrics.Gauge;
import com.gigaspaces.metrics.Metric;
import com.gigaspaces.metrics.ServiceMetric;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.pu.container.ProcessingUnitContainerContext;
import org.openspaces.pu.container.ProcessingUnitContainerContextAware;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;

public class ProcessingUnitContainerContextBeanPostProcessor
implements BeanPostProcessor {
    private static final Log logger = LogFactory.getLog(ProcessingUnitContainerContextBeanPostProcessor.class);
    private final ProcessingUnitContainerContext processingUnitContainerContext;

    public ProcessingUnitContainerContextBeanPostProcessor(ProcessingUnitContainerContext processingUnitContainerContext) {
        this.processingUnitContainerContext = processingUnitContainerContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.processProcessingUnitContainerContextAware(bean);
        this.processMetrics(bean, beanName);
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private void processProcessingUnitContainerContextAware(Object bean) {
        if (bean instanceof ProcessingUnitContainerContextAware) {
            ((ProcessingUnitContainerContextAware)bean).setProcessingUnitContainerContext(this.processingUnitContainerContext);
        }
    }

    private void processMetrics(final Object bean, final String beanName) {
        final AtomicReference metricManagerHolder = new AtomicReference();
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                Metric metric;
                ServiceMetric annotation = method.getAnnotation(ServiceMetric.class);
                if (annotation != null && (metric = ProcessingUnitContainerContextBeanPostProcessor.getMetricFromMethod(method, bean)) != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Registering custom metric " + annotation.name()));
                    }
                    if (metricManagerHolder.get() == null) {
                        metricManagerHolder.set(ProcessingUnitContainerContextBeanPostProcessor.this.processingUnitContainerContext.createBeanMetricManager(beanName));
                    }
                    ((BeanMetricManager)metricManagerHolder.get()).register(annotation.name(), metric);
                }
            }
        });
    }

    private static Metric getMetricFromMethod(final Method method, final Object bean) {
        if (method.getParameterTypes().length != 0) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Metric registration of method " + method.getName() + " in " + bean.getClass().getName() + " is skipped - metric method cannot have parameters"));
            }
            return null;
        }
        if (method.getReturnType().equals(Void.TYPE)) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Metric registration of method " + method.getName() + " in " + bean.getClass().getName() + " is skipped - metric method cannot return void"));
            }
            return null;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Metric registration of method " + method.getName() + " in " + bean.getClass().getName() + " is skipped - metric method cannot be static"));
            }
            return null;
        }
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        if (Metric.class.isAssignableFrom(method.getReturnType())) {
            try {
                return (Metric)method.invoke(bean, new Object[0]);
            }
            catch (IllegalAccessException e) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Metric registration of method " + method.getName() + " in " + bean.getClass().getName() + " is skipped - failed to get metric - " + e.getMessage()));
                }
                return null;
            }
            catch (InvocationTargetException e) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Metric registration of method " + method.getName() + " in " + bean.getClass().getName() + " is skipped - failed to get metric - " + e.getMessage()));
                }
                return null;
            }
        }
        return new Gauge<Object>(){

            public Object getValue() throws Exception {
                return method.invoke(bean, new Object[0]);
            }
        };
    }
}

