/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.integrated;

import com.gigaspaces.admin.cli.RuntimeInfo;
import com.gigaspaces.logger.GSLogConfigLoader;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.pu.container.CannotCloseContainerException;
import org.openspaces.pu.container.ProcessingUnitContainer;
import org.openspaces.pu.container.integrated.IntegratedProcessingUnitContainerProvider;
import org.openspaces.pu.container.spi.ApplicationContextProcessingUnitContainer;
import org.openspaces.pu.container.support.BeanLevelPropertiesParser;
import org.openspaces.pu.container.support.ClusterInfoParser;
import org.openspaces.pu.container.support.CommandLineParser;
import org.openspaces.pu.container.support.ConfigLocationParser;
import org.openspaces.pu.container.support.SpaceNameParser;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;

public class IntegratedProcessingUnitContainer
extends ApplicationContextProcessingUnitContainer {
    private static final Log logger = LogFactory.getLog(IntegratedProcessingUnitContainer.class);
    private final ApplicationContext applicationContext;

    public IntegratedProcessingUnitContainer(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public void close() throws CannotCloseContainerException {
        if (this.applicationContext instanceof DisposableBean) {
            try {
                ((DisposableBean)this.applicationContext).destroy();
            }
            catch (Exception e) {
                throw new CannotCloseContainerException("Failed to close container with application context [" + this.applicationContext + "]", e);
            }
        }
        super.close();
    }

    public static void main(String[] args) throws Exception {
        GSLogConfigLoader.getLoader();
        IntegratedProcessingUnitContainer.showUsageOptionsOnHelpCommand(args);
        logger.info((Object)("Starting with args: " + Arrays.toString(args) + "\n" + RuntimeInfo.getEnvironmentInfoIfFirstTime()));
        try {
            final ProcessingUnitContainer container = IntegratedProcessingUnitContainer.createContainer(args);
            logger.info((Object)"Started successfully");
            final Thread mainThread = Thread.currentThread();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        logger.info((Object)"Shutdown hook triggered");
                        container.close();
                        logger.info((Object)"Shutdown complete");
                    }
                    finally {
                        mainThread.interrupt();
                    }
                }
            });
            while (!mainThread.isInterrupted()) {
                try {
                    Thread.sleep(Long.MAX_VALUE);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception e) {
            IntegratedProcessingUnitContainer.printUsage();
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private static void showUsageOptionsOnHelpCommand(String[] args) {
        for (String arg : args) {
            if (!arg.equals("--help")) continue;
            IntegratedProcessingUnitContainer.printUsage();
            System.exit(0);
        }
    }

    public static ProcessingUnitContainer createContainer(String[] args) throws Exception {
        CommandLineParser.Parameter[] params = CommandLineParser.parse(args);
        IntegratedProcessingUnitContainerProvider provider = new IntegratedProcessingUnitContainerProvider();
        provider.setBeanLevelProperties(BeanLevelPropertiesParser.parse(params));
        provider.setClusterInfo(ClusterInfoParser.parse(params));
        ConfigLocationParser.parse(provider, params);
        provider.setSpaceName(SpaceNameParser.parse(params));
        String userName = null;
        String password = null;
        for (CommandLineParser.Parameter param : params) {
            if (param.getName().equals("user")) {
                userName = param.getArguments()[0];
                continue;
            }
            if (param.getName().equals("password")) {
                password = param.getArguments()[0];
                continue;
            }
            if (!param.getName().equals("secured")) continue;
            provider.setSecured(Boolean.parseBoolean(param.getArguments()[0]));
        }
        if (userName != null && password != null) {
            provider.setUserDetails(userName, password);
        }
        return provider.createContainer();
    }

    public static void printUsage() {
        System.out.println("usage options: [-name ...] [-cluster ...] [-properties ...] [-user xxx -password yyy] [-secured true/false]");
        System.out.println();
        System.out.println("    --help                                   : Shows this usage options menu");
        System.out.println();
        System.out.println("    <no parameters>                          : by default uses classpath*:/META-INF/spring/pu.xml");
        System.out.println("    -name [data grid name]                   : Specify the data grid name (required if pu.xml not found)");
        System.out.println("    -cluster [cluster properties]            : Allows to specify cluster parameters");
        System.out.println("             schema=partitioned              : The cluster schema to use (default is partitioned)");
        System.out.println("             total_members=1,1               : The number of instances and number of backups to use");
        System.out.println("             id=1                            : The instance id of this processing unit");
        System.out.println("             backup_id=1                     : The backup id of this processing unit");
        System.out.println("    -properties [properties-loc]             : Location of context level properties");
        System.out.println("    -properties [bean-name] [properties-loc] : Location of properties used applied only for a specified bean");
        System.out.println("    -user x -password y                      : Configures a secured processing unit propagated with the supplied user and password");
        System.out.println("    -secured true                            : Configures a secured processing unit (implicit when using -user/-password)");
        System.out.println();
        System.out.println();
        System.out.println("Some Examples:");
        System.out.println();
        System.out.println("1. -name myDataGrid");
        System.out.println("    > Starts a processing unit with a non-clustered data grid instance named myDataGrid");
        System.out.println();
        System.out.println("2. -cluster schema=partitioned total_members=2,1");
        System.out.println("    > Starts a processing unit with a partitioned cluster schema of two members (with one backup each) all in one process");
        System.out.println("    > add -name myDataGrid to provide the cluster with a name, and each instance will follow the naming convention: ");
        System.out.println("       first  partition: dataGrid.1 , backup of first  partition: dataGrid.1_1");
        System.out.println("       second partition: dataGrid.2 , backup of second partition: dataGrid.2_1");
        System.out.println();
        System.out.println("3. -cluster schema=partitioned total_members=2,1 id=1");
        System.out.println("    - Starts only the first instance (id=1) of a processing unit belonging to a 2,1 partitioned cluster (two members with one backup each)");
        System.out.println();
        System.out.println("4. -cluster schema=partitioned total_members=2,1 id=1 backup_id=1");
        System.out.println("    - Starts only the backup of the first instance (id=1) of a processing unit belonging to a 2,1 partitioned cluster (two members with one backup each)");
        System.out.println();
        System.out.println("5. -cluster schema=partitioned total_members=2,0");
        System.out.println("    > Starts a processing unit with a partitioned cluster schema of two members (without any backups) all in one process");
        System.out.println();
        System.out.println("6. -cluster schema=partitioned total_members=2,0 id=1");
        System.out.println("    > Starts only the first instance (id=1) of a processing unit belonging to a 2,0 partitioned cluster (two members without any backups)");
        System.out.println();
        System.out.println("7. -properties file://config/context.properties -properties space1 file://config/space1.properties");
        System.out.println("    > Starts a processing unit using context level properties (context.properties) and bean level properties (space1.properties) applied to bean named space1");
        System.out.println();
        System.out.println("8. -properties embed://prop1=value1 -properties space1 embed://prop2=value2;prop3=value3");
        System.out.println("    > Starts a processing unit using context level properties with a single property called prop1 with value1 and bean level properties with two properties");
        System.out.println();
        System.out.println("9. -secured true");
        System.out.println("    > Starts a processing unit with a secured data grid");
        System.out.println();
    }
}

