/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.integrated;

import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.CredentialsProviderHelper;
import com.gigaspaces.security.directory.DefaultCredentialsProvider;
import com.gigaspaces.security.directory.UserDetails;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.properties.BeanLevelProperties;
import org.openspaces.pu.container.CannotCreateContainerException;
import org.openspaces.pu.container.ProcessingUnitContainer;
import org.openspaces.pu.container.ProcessingUnitContainerConfig;
import org.openspaces.pu.container.integrated.IntegratedProcessingUnitContainer;
import org.openspaces.pu.container.spi.ApplicationContextProcessingUnitContainerProvider;
import org.openspaces.pu.container.support.ClusterInfoParser;
import org.openspaces.pu.container.support.CompoundProcessingUnitContainer;
import org.openspaces.pu.container.support.ResourceApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class IntegratedProcessingUnitContainerProvider
extends ApplicationContextProcessingUnitContainerProvider {
    private static final Log logger = LogFactory.getLog(IntegratedProcessingUnitContainerProvider.class);
    private ApplicationContext parentContext;
    private final List<Resource> configResources = new ArrayList<Resource>();
    private ClassLoader classLoader;
    private CredentialsProvider credentialsProvider;
    private Boolean secured;

    public void setParentContext(ApplicationContext parentContext) {
        this.parentContext = parentContext;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void addConfigLocation(Resource resource) {
        this.configResources.add(resource);
    }

    @Deprecated
    public void setUserDetails(UserDetails userDetails) {
        this.credentialsProvider = new DefaultCredentialsProvider(userDetails);
    }

    @Deprecated
    public void setUserDetails(String username, String password) {
        this.setCredentials(username, password);
    }

    public void setCredentials(String username, String password) {
        this.credentialsProvider = new DefaultCredentialsProvider(username, password);
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void setSecured(Boolean secured) {
        this.secured = secured;
    }

    @Override
    public void addConfigLocation(String path) throws IOException {
        Resource[] resources;
        for (Resource resource : resources = new PathMatchingResourcePatternResolver().getResources(path)) {
            this.addConfigLocation(resource);
        }
    }

    @Override
    public ProcessingUnitContainer createContainer() throws CannotCreateContainerException {
        ProcessingUnitContainerConfig config;
        ClusterInfo clusterInfo;
        if (this.configResources.size() == 0) {
            try {
                this.addConfigLocation("classpath*:/META-INF/spring/pu.xml");
                boolean foundValidResource = false;
                for (Resource resource : this.configResources) {
                    if (!resource.exists()) continue;
                    foundValidResource = true;
                    break;
                }
                if (!foundValidResource) {
                    this.addConfigLocation((Resource)new FileSystemResource("META-INF/spring/pu.xml"));
                    for (Resource resource : this.configResources) {
                        if (resource.exists()) continue;
                        throw new CannotCreateContainerException("No explicit config location, tried [classpath*:/META-INF/spring/pu.xml], [META-INF/spring/pu.xml] (relative to working director), [pu.config], and no configuration found");
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("No explicit config location, default location [classpath*:/META-INF/spring/pu.xml] has no configuration, loading from [META-INF/spring/pu.xml] relative to working directory [" + new File(".").getAbsolutePath() + "]"));
                    } else {
                        logger.debug((Object)"No explicit config location, defaulting to [classpath*:/META-INF/spring/pu.xml]");
                    }
                }
            }
            catch (IOException e) {
                throw new CannotCreateContainerException("Failed to read config files from classpath*:/META-INF/spring/pu.xml", e);
            }
        }
        if ((clusterInfo = (config = this.getConfig()).getClusterInfo()) != null) {
            ClusterInfoParser.guessSchema(clusterInfo);
        }
        if (clusterInfo != null && clusterInfo.getInstanceId() == null && clusterInfo.getNumberOfInstances() != null) {
            ClusterInfo origClusterInfo = clusterInfo;
            ArrayList<ProcessingUnitContainer> containers = new ArrayList<ProcessingUnitContainer>();
            for (int i = 0; i < clusterInfo.getNumberOfInstances(); ++i) {
                ClusterInfo containerClusterInfo = clusterInfo.copy();
                containerClusterInfo.setInstanceId(i + 1);
                containerClusterInfo.setBackupId(null);
                this.setClusterInfo(containerClusterInfo);
                containers.add(this.createContainer());
                if (clusterInfo.getNumberOfBackups() == null) continue;
                for (int j = 0; j < clusterInfo.getNumberOfBackups(); ++j) {
                    containerClusterInfo = containerClusterInfo.copy();
                    containerClusterInfo.setBackupId(j + 1);
                    this.setClusterInfo(containerClusterInfo);
                    containers.add(this.createContainer());
                }
            }
            this.setClusterInfo(origClusterInfo);
            return new CompoundProcessingUnitContainer(containers.toArray(new ProcessingUnitContainer[containers.size()]));
        }
        BeanLevelProperties beanLevelProperties = config.getBeanLevelProperties();
        if (this.credentialsProvider != null) {
            try {
                CredentialsProviderHelper.appendMarshalledCredentials((Properties)beanLevelProperties.getContextProperties(), null, (CredentialsProvider)this.credentialsProvider);
            }
            catch (IOException e) {
                throw new CannotCreateContainerException("Failed to marshall user details", e);
            }
        } else if (this.secured != null) {
            beanLevelProperties.getContextProperties().setProperty("secured", "true");
        }
        Resource[] resources = this.configResources.toArray(new Resource[this.configResources.size()]);
        ResourceApplicationContext applicationContext = new ResourceApplicationContext(resources, this.parentContext, config);
        if (this.classLoader != null) {
            applicationContext.setClassLoader(this.classLoader);
        }
        applicationContext.refresh();
        return new IntegratedProcessingUnitContainer((ApplicationContext)applicationContext);
    }
}

