/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.jee;

import com.gigaspaces.start.ClasspathBuilder;
import com.gigaspaces.start.Locator;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jini.rio.boot.SharedServiceData;
import org.openspaces.core.properties.BeanLevelProperties;
import org.openspaces.pu.container.spi.ApplicationContextProcessingUnitContainerProvider;
import org.openspaces.pu.container.support.ResourceApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public abstract class JeeProcessingUnitContainerProvider
extends ApplicationContextProcessingUnitContainerProvider {
    public static final String CLUSTER_INFO_CONTEXT = "clusterInfo";
    public static final String BEAN_LEVEL_PROPERTIES_CONTEXT = "beanLevelProperties";
    public static final String JETTY_PORT_CONTEXT_PREFIX = "jetty";
    public static final String JETTY_PORT_CONTEXT_SUFFIX = ".port.actual";
    public static final String JETTY_PORT_ACTUAL_CONTEXT = "jetty.port.actual";
    public static final String APPLICATION_CONTEXT_CONTEXT = "applicationContext";
    public static final String JEE_CONTAINER_PROPERTY_NAME = "jee.container";
    public static final String DEFAULT_JEE_CONTAINER = "jetty";
    private ClassLoader classLoader;
    private File deployPath;
    private final List<Resource> configResources = new ArrayList<Resource>();
    private Iterable<URL> manifestURLs;
    private ApplicationContext parentContext;

    public abstract String getJeeContainerType();

    public Iterable<URL> getManifestURLs() {
        return this.manifestURLs;
    }

    @Override
    public void setManifestUrls(Iterable<URL> manifestURLs) {
        this.manifestURLs = manifestURLs;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void setDeployPath(File warPath) {
        this.deployPath = warPath;
    }

    public File getDeployPath() {
        return this.deployPath;
    }

    @Override
    public void addConfigLocation(Resource resource) {
        this.configResources.add(resource);
    }

    @Override
    public void addConfigLocation(String path) throws IOException {
        Resource[] resources;
        for (Resource resource : resources = new PathMatchingResourcePatternResolver().getResources(path)) {
            this.addConfigLocation(resource);
        }
    }

    public void setParentContext(ApplicationContext parentContext) {
        this.parentContext = parentContext;
    }

    protected Iterable<String> getWebAppClassLoaderJars() {
        ArrayList<String> result = new ArrayList<String>();
        String gsLibOpt = Locator.getLibOptional();
        result.add(System.getProperty("com.gs.pu-common", gsLibOpt + "pu-common"));
        result.add(System.getProperty("com.gs.web-pu-common", gsLibOpt + "web-pu-common"));
        return result;
    }

    protected Iterable<String> getWebAppClassLoaderClassPath() {
        return new ClasspathBuilder().append(JeeProcessingUnitContainerProvider.getJeeContainerJarPath(this.getJeeContainerType())).toFilesNames();
    }

    protected ClassLoader getJeeClassLoader() throws Exception {
        return SharedServiceData.getJeeClassLoader((String)this.getJeeContainerType(), (String[])new String[0]);
    }

    protected ResourceApplicationContext initApplicationContext() {
        Resource[] resources = this.configResources.toArray(new Resource[this.configResources.size()]);
        ResourceApplicationContext applicationContext = new ResourceApplicationContext(resources, this.parentContext, this.getConfig());
        if (this.classLoader != null) {
            applicationContext.setClassLoader(this.classLoader);
        }
        return applicationContext;
    }

    public static String getJeeContainerJarPath(String jeeContainer) {
        return Locator.getLibOptional() + jeeContainer + "/xap-" + jeeContainer;
    }

    public static String getJeeContainer(BeanLevelProperties properties) {
        return properties.getContextProperties().getProperty(JEE_CONTAINER_PROPERTY_NAME, "jetty");
    }
}

