/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.jee.context;

import com.gigaspaces.internal.dump.InternalDumpProcessor;
import com.gigaspaces.internal.utils.ClassLoaderUtils;
import com.gigaspaces.start.SystemBoot;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jini.rio.boot.SharedServiceData;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.cluster.MemberAliveIndicator;
import org.openspaces.core.cluster.ProcessingUnitUndeployingListener;
import org.openspaces.core.properties.BeanLevelProperties;
import org.openspaces.pu.container.ProcessingUnitContainerConfig;
import org.openspaces.pu.container.jee.JeeProcessingUnitContainerProvider;
import org.openspaces.pu.container.jee.stats.RequestStatisticsFilter;
import org.openspaces.pu.container.support.ResourceApplicationContext;
import org.openspaces.pu.service.ServiceDetails;
import org.openspaces.pu.service.ServiceDetailsProvider;
import org.openspaces.pu.service.ServiceMonitors;
import org.openspaces.pu.service.ServiceMonitorsProvider;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class BootstrapWebApplicationContextListener
implements ServletContextListener {
    private static final Log logger = LogFactory.getLog(BootstrapWebApplicationContextListener.class);
    private static final String BOOTSTRAP_CONTEXT_KEY = BootstrapWebApplicationContextListener.class.getName() + ".bootstraped";
    private static final String MARSHALLED_STORE = "/WEB-INF/gsstore";
    private static final String MARSHALLED_CLUSTER_INFO = "/WEB-INF/gsstore/cluster-info";
    private static final String MARSHALLED_BEAN_LEVEL_PROPERTIES = "/WEB-INF/gsstore/bean-level-properties";
    private volatile ServletContextListener jeeContainerContextListener;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        Boolean bootstraped = (Boolean)servletContext.getAttribute(BOOTSTRAP_CONTEXT_KEY);
        if (bootstraped != null && bootstraped.booleanValue()) {
            logger.debug((Object)"Already performed bootstrap, ignoring");
            return;
        }
        servletContext.setAttribute(BOOTSTRAP_CONTEXT_KEY, (Object)true);
        logger.info((Object)"Booting OpenSpaces Web Application Support");
        logger.info((Object)ClassLoaderUtils.getCurrentClassPathString((String)"Web Class Loader"));
        ProcessingUnitContainerConfig config = new ProcessingUnitContainerConfig();
        InputStream is = servletContext.getResourceAsStream(MARSHALLED_CLUSTER_INFO);
        if (is != null) {
            try {
                config.setClusterInfo((ClusterInfo)BootstrapWebApplicationContextListener.objectFromByteBuffer(FileCopyUtils.copyToByteArray((InputStream)is)));
                servletContext.setAttribute("clusterInfo", (Object)config.getClusterInfo());
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to read cluster info from /WEB-INF/gsstore/cluster-info", (Throwable)e);
            }
        } else {
            logger.debug((Object)"No cluster info found at /WEB-INF/gsstore/cluster-info");
        }
        is = servletContext.getResourceAsStream(MARSHALLED_BEAN_LEVEL_PROPERTIES);
        if (is != null) {
            try {
                config.setBeanLevelProperties((BeanLevelProperties)BootstrapWebApplicationContextListener.objectFromByteBuffer(FileCopyUtils.copyToByteArray((InputStream)is)));
                servletContext.setAttribute("beanLevelProperties", (Object)config.getBeanLevelProperties());
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to read bean level properties from /WEB-INF/gsstore/bean-level-properties", (Throwable)e);
            }
        } else {
            logger.debug((Object)"No bean level properties found at /WEB-INF/gsstore/bean-level-properties");
        }
        FileSystemResource resource = null;
        String realPath = servletContext.getRealPath("/META-INF/spring/pu.xml");
        if (realPath != null) {
            resource = new FileSystemResource(realPath);
        }
        if (resource != null && resource.exists()) {
            String[] beanNames;
            logger.debug((Object)("Loading [" + resource + "]"));
            final ResourceApplicationContext applicationContext = new ResourceApplicationContext(new Resource[]{resource}, null, config);
            applicationContext.refresh();
            servletContext.setAttribute("applicationContext", (Object)applicationContext);
            for (String beanName : beanNames = applicationContext.getBeanDefinitionNames()) {
                if (applicationContext.getType(beanName) == null) continue;
                servletContext.setAttribute(beanName, applicationContext.getBean(beanName));
            }
            if (config.getClusterInfo() != null && SystemBoot.isRunningWithinGSC()) {
                String key = config.getClusterInfo().getUniqueName();
                SharedServiceData.addServiceDetails((String)key, (Callable)new Callable(){

                    public Object call() throws Exception {
                        ArrayList<ServiceDetails> serviceDetails = new ArrayList<ServiceDetails>();
                        Map map = applicationContext.getBeansOfType(ServiceDetailsProvider.class);
                        Iterator it = map.values().iterator();
                        while (it.hasNext()) {
                            ServiceDetails[] details = ((ServiceDetailsProvider)it.next()).getServicesDetails();
                            if (details == null) continue;
                            for (ServiceDetails detail : details) {
                                serviceDetails.add(detail);
                            }
                        }
                        return serviceDetails.toArray(new Object[serviceDetails.size()]);
                    }
                });
                SharedServiceData.addServiceMonitors((String)key, (Callable)new Callable(){

                    public Object call() throws Exception {
                        ArrayList<ServiceMonitors> serviceMonitors = new ArrayList<ServiceMonitors>();
                        Map map = applicationContext.getBeansOfType(ServiceMonitorsProvider.class);
                        Iterator it = map.values().iterator();
                        while (it.hasNext()) {
                            ServiceMonitors[] monitors = ((ServiceMonitorsProvider)it.next()).getServicesMonitors();
                            if (monitors == null) continue;
                            for (ServiceMonitors monitor : monitors) {
                                serviceMonitors.add(monitor);
                            }
                        }
                        return serviceMonitors.toArray(new Object[serviceMonitors.size()]);
                    }
                });
                Map map = applicationContext.getBeansOfType(MemberAliveIndicator.class);
                for (final MemberAliveIndicator memberAliveIndicator : map.values()) {
                    if (!memberAliveIndicator.isMemberAliveEnabled()) continue;
                    SharedServiceData.addMemberAliveIndicator((String)key, (Callable)new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return memberAliveIndicator.isAlive();
                        }
                    });
                }
                map = applicationContext.getBeansOfType(ProcessingUnitUndeployingListener.class);
                for (final ProcessingUnitUndeployingListener listener : map.values()) {
                    SharedServiceData.addUndeployingEventListener((String)key, (Callable)new Callable(){

                        public Object call() throws Exception {
                            listener.processingUnitUndeploying();
                            return null;
                        }
                    });
                }
                map = applicationContext.getBeansOfType(InternalDumpProcessor.class);
                Iterator it = map.values().iterator();
                while (it.hasNext()) {
                    SharedServiceData.addDumpProcessors((String)key, it.next());
                }
            }
        } else {
            logger.debug((Object)"No [classpath*:/META-INF/spring/pu.xml] to load");
        }
        if (config.getBeanLevelProperties() != null) {
            String jeeContainer = JeeProcessingUnitContainerProvider.getJeeContainer(config.getBeanLevelProperties());
            String className = "org.openspaces.pu.container.jee." + jeeContainer + "." + StringUtils.capitalize((String)jeeContainer) + "WebApplicationContextListener";
            Class<?> clazz = null;
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException map) {
                // empty catch block
            }
            if (clazz != null) {
                try {
                    this.jeeContainerContextListener = (ServletContextListener)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create JEE specific context listener [" + clazz.getName() + "]", e);
                }
                this.jeeContainerContextListener.contextInitialized(servletContextEvent);
            }
        }
        if (config.getClusterInfo() != null && SystemBoot.isRunningWithinGSC()) {
            SharedServiceData.putWebAppClassLoader((String)config.getClusterInfo().getUniqueName(), (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        ConfigurableApplicationContext applicationContext;
        if (this.jeeContainerContextListener != null) {
            this.jeeContainerContextListener.contextDestroyed(servletContextEvent);
        }
        if ((applicationContext = (ConfigurableApplicationContext)servletContextEvent.getServletContext().getAttribute("applicationContext")) != null && applicationContext.isActive()) {
            applicationContext.close();
        }
    }

    public static void prepareForBoot(File warPath, ClusterInfo clusterInfo, BeanLevelProperties beanLevelProperties) throws Exception {
        String line;
        File gsStore = new File(warPath, MARSHALLED_STORE);
        gsStore.mkdirs();
        if (clusterInfo != null) {
            FileCopyUtils.copy((byte[])BootstrapWebApplicationContextListener.objectToByteBuffer(clusterInfo), (File)new File(warPath, MARSHALLED_CLUSTER_INFO));
        }
        if (beanLevelProperties != null) {
            FileCopyUtils.copy((byte[])BootstrapWebApplicationContextListener.objectToByteBuffer(beanLevelProperties), (File)new File(warPath, MARSHALLED_BEAN_LEVEL_PROPERTIES));
        }
        new File(warPath, "/WEB-INF/web.xml").renameTo(new File(warPath, "/WEB-INF/web.xml.orig"));
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(warPath, "/WEB-INF/web.xml.orig"))));
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(warPath, "/WEB-INF/web.xml"), false))));
        while ((line = reader.readLine()) != null) {
            if ((line = line.replace("org.springframework.web.context.ContextLoaderListener", "org.openspaces.pu.container.jee.context.ProcessingUnitContextLoaderListener")).indexOf("<web-app") != -1) {
                writer.println(line);
                if (line.indexOf(62) == -1) {
                    while ((line = reader.readLine()) != null && line.indexOf(62) == -1) {
                        writer.println(line);
                    }
                    writer.println(line);
                }
                writer.println("<!-- GigaSpaces CHANGE START: Boot Listener -->");
                writer.println("<listener>");
                writer.println("    <listener-class>" + BootstrapWebApplicationContextListener.class.getName() + "</listener-class>");
                writer.println("</listener>");
                writer.println("<!-- GigaSpaces CHANGE END: Boot Listener -->");
                writer.println("<!-- GigaSpaces CHANGE START: Request Statistics Listener -->");
                writer.println("<filter>");
                writer.println("    <filter-name>gs-request-statistics</filter-name>");
                writer.println("    <filter-class>" + RequestStatisticsFilter.class.getName() + "</filter-class>");
                if (!Boolean.getBoolean("com.gs.cancel-async-supported")) {
                    writer.println("<async-supported>true</async-supported>");
                }
                writer.println("</filter>");
                writer.println("<filter-mapping>");
                writer.println("    <filter-name>gs-request-statistics</filter-name>");
                writer.println("    <url-pattern>/*</url-pattern>");
                writer.println("</filter-mapping>");
                writer.println("<!-- GigaSpaces CHANGE END: Request Statistics Listener -->");
                continue;
            }
            writer.println(line);
        }
        writer.close();
        reader.close();
    }

    public static Object objectFromByteBuffer(byte[] buffer) throws Exception {
        if (buffer == null) {
            return null;
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(buffer);
        ObjectInputStream in = new ObjectInputStream(inStream);
        Object retval = in.readObject();
        in.close();
        return retval;
    }

    public static byte[] objectToByteBuffer(Object obj) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(outStream);
        out.writeObject(obj);
        out.flush();
        byte[] result = outStream.toByteArray();
        out.close();
        outStream.close();
        return result;
    }
}

