/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.jee.context;

import com.gigaspaces.internal.dump.InternalDumpProcessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.ServletContext;
import org.jini.rio.boot.SharedServiceData;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.cluster.MemberAliveIndicator;
import org.openspaces.core.cluster.ProcessingUnitUndeployingListener;
import org.openspaces.core.properties.BeanLevelProperties;
import org.openspaces.pu.container.ProcessingUnitContainerConfig;
import org.openspaces.pu.container.jee.context.ProcessingUnitWebApplicationContext;
import org.openspaces.pu.service.ServiceDetails;
import org.openspaces.pu.service.ServiceDetailsProvider;
import org.openspaces.pu.service.ServiceMonitors;
import org.openspaces.pu.service.ServiceMonitorsProvider;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public class ProcessingUnitContextLoader
extends ContextLoader {
    public WebApplicationContext initWebApplicationContext(ServletContext servletContext) throws IllegalStateException, BeansException {
        final WebApplicationContext context = super.initWebApplicationContext(servletContext);
        ClusterInfo clusterInfo = (ClusterInfo)servletContext.getAttribute("clusterInfo");
        if (clusterInfo != null) {
            String key = clusterInfo.getUniqueName();
            SharedServiceData.addServiceDetails((String)key, (Callable)new Callable(){

                public Object call() throws Exception {
                    ArrayList<ServiceDetails> serviceDetails = new ArrayList<ServiceDetails>();
                    Map map = context.getBeansOfType(ServiceDetailsProvider.class);
                    Iterator it = map.values().iterator();
                    while (it.hasNext()) {
                        ServiceDetails[] details = ((ServiceDetailsProvider)it.next()).getServicesDetails();
                        if (details == null) continue;
                        for (ServiceDetails detail : details) {
                            serviceDetails.add(detail);
                        }
                    }
                    return serviceDetails.toArray(new Object[serviceDetails.size()]);
                }
            });
            SharedServiceData.addServiceMonitors((String)key, (Callable)new Callable(){

                public Object call() throws Exception {
                    ArrayList<ServiceMonitors> serviceMonitors = new ArrayList<ServiceMonitors>();
                    Map map = context.getBeansOfType(ServiceMonitorsProvider.class);
                    Iterator it = map.values().iterator();
                    while (it.hasNext()) {
                        ServiceMonitors[] monitors = ((ServiceMonitorsProvider)it.next()).getServicesMonitors();
                        if (monitors == null) continue;
                        for (ServiceMonitors monitor : monitors) {
                            serviceMonitors.add(monitor);
                        }
                    }
                    return serviceMonitors.toArray(new Object[serviceMonitors.size()]);
                }
            });
            Map map = context.getBeansOfType(MemberAliveIndicator.class);
            for (final MemberAliveIndicator memberAliveIndicator : map.values()) {
                if (!memberAliveIndicator.isMemberAliveEnabled()) continue;
                SharedServiceData.addMemberAliveIndicator((String)key, (Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return memberAliveIndicator.isAlive();
                    }
                });
            }
            map = context.getBeansOfType(ProcessingUnitUndeployingListener.class);
            for (final ProcessingUnitUndeployingListener listener : map.values()) {
                SharedServiceData.addUndeployingEventListener((String)key, (Callable)new Callable(){

                    public Object call() throws Exception {
                        listener.processingUnitUndeploying();
                        return null;
                    }
                });
            }
            map = context.getBeansOfType(InternalDumpProcessor.class);
            Iterator it = map.values().iterator();
            while (it.hasNext()) {
                SharedServiceData.addDumpProcessors((String)key, it.next());
            }
        }
        return context;
    }

    protected ApplicationContext loadParentContext(ServletContext servletContext) throws BeansException {
        return (ApplicationContext)servletContext.getAttribute("applicationContext");
    }

    protected WebApplicationContext createWebApplicationContext(ServletContext servletContext, ApplicationContext parent) throws BeansException {
        ProcessingUnitContainerConfig config = new ProcessingUnitContainerConfig();
        config.setClusterInfo((ClusterInfo)servletContext.getAttribute("clusterInfo"));
        config.setBeanLevelProperties((BeanLevelProperties)servletContext.getAttribute("beanLevelProperties"));
        ProcessingUnitWebApplicationContext wac = new ProcessingUnitWebApplicationContext(config);
        wac.setParent(parent);
        wac.setServletContext(servletContext);
        wac.setConfigLocation(servletContext.getInitParameter("contextConfigLocation"));
        this.customizeContext(servletContext, (ConfigurableWebApplicationContext)wac);
        wac.refresh();
        return wac;
    }
}

