/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.jee.context;

import java.util.ArrayList;
import java.util.List;
import org.openspaces.core.cluster.ClusterInfoBeanPostProcessor;
import org.openspaces.core.cluster.ClusterInfoPropertyPlaceholderConfigurer;
import org.openspaces.core.properties.BeanLevelPropertyBeanPostProcessor;
import org.openspaces.core.properties.BeanLevelPropertyPlaceholderConfigurer;
import org.openspaces.pu.container.ProcessingUnitContainerConfig;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class ProcessingUnitWebApplicationContext
extends XmlWebApplicationContext {
    private List<BeanPostProcessor> beanPostProcessors = new ArrayList<BeanPostProcessor>();

    public ProcessingUnitWebApplicationContext(ProcessingUnitContainerConfig config) {
        if (config.getBeanLevelProperties() != null) {
            this.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new BeanLevelPropertyPlaceholderConfigurer(config.getBeanLevelProperties(), config.getClusterInfo()));
            this.addBeanPostProcessor(new BeanLevelPropertyBeanPostProcessor(config.getBeanLevelProperties()));
        }
        if (config.getClusterInfo() != null) {
            this.addBeanPostProcessor(new ClusterInfoBeanPostProcessor(config.getClusterInfo()));
            this.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new ClusterInfoPropertyPlaceholderConfigurer(config.getClusterInfo()));
        }
    }

    public void addBeanPostProcessor(BeanPostProcessor beanPostProcessor) {
        this.beanPostProcessors.add(beanPostProcessor);
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        DefaultListableBeanFactory beanFactory = super.createBeanFactory();
        for (BeanPostProcessor beanPostProcessor : this.beanPostProcessors) {
            beanFactory.addBeanPostProcessor(beanPostProcessor);
        }
        return beanFactory;
    }
}

