/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.jee.stats;

import com.gigaspaces.time.SystemTime;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jini.rio.boot.SharedServiceData;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.pu.container.jee.stats.WebRequestsServiceMonitors;
import org.openspaces.pu.service.ServiceMonitors;
import org.openspaces.pu.service.ServiceMonitorsProvider;

public class RequestStatisticsFilter
implements Filter,
ServiceMonitorsProvider {
    private static Log logger = LogFactory.getLog(RequestStatisticsFilter.class);
    private AtomicLong requests;
    private AtomicLong reqeustsActive;
    private AtomicLong requestsDurationTotal;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.requests = new AtomicLong();
        this.reqeustsActive = new AtomicLong();
        this.requestsDurationTotal = new AtomicLong();
        ClusterInfo clusterInfo = (ClusterInfo)filterConfig.getServletContext().getAttribute("clusterInfo");
        if (clusterInfo == null) {
            logger.warn((Object)"Failed to find cluster info, can't register JEE request service monitor");
        } else {
            SharedServiceData.addServiceMonitors((String)clusterInfo.getUniqueName(), (Callable)new Callable(){

                public Object call() throws Exception {
                    return RequestStatisticsFilter.this.getServicesMonitors();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        long now = SystemTime.timeMillis();
        try {
            this.reqeustsActive.incrementAndGet();
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            this.reqeustsActive.decrementAndGet();
            long requestDuration = SystemTime.timeMillis() - now;
            this.requestsDurationTotal.getAndAdd(requestDuration);
            this.requests.incrementAndGet();
        }
    }

    public void destroy() {
    }

    @Override
    public ServiceMonitors[] getServicesMonitors() {
        return new ServiceMonitors[]{new WebRequestsServiceMonitors("jee-container", this.requests.get(), this.reqeustsActive.get(), this.requestsDurationTotal.get())};
    }
}

