/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.jee.stats;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openspaces.pu.service.PlainServiceMonitors;

public class WebRequestsServiceMonitors
extends PlainServiceMonitors {
    private static final long serialVersionUID = 1345686383755041069L;

    public WebRequestsServiceMonitors() {
    }

    public WebRequestsServiceMonitors(String id, long requests, long requestsActive, long requestsDurationTotal) {
        super(id);
        this.getMonitors().put("total", requests);
        this.getMonitors().put("active", requestsActive);
        this.getMonitors().put("duration-total", requestsDurationTotal);
        this.getMonitors().put("requests-throughput", Float.valueOf(-1.0f));
        this.getMonitors().put("average-requests-latency", Float.valueOf(-1.0f));
    }

    public void setPrevious(WebRequestsServiceMonitors previous, long timeout) {
        float requestsThroughput = -1.0f;
        float averageRequetsLatency = -1.0f;
        if (previous != null) {
            requestsThroughput = 1000.0f * (float)(this.getTotal() - previous.getTotal()) / (float)timeout;
            long requestsDelta = this.getTotal() - previous.getTotal();
            long durationDelta = this.getTotalDuration() - previous.getTotalDuration();
            if (durationDelta != 0L) {
                averageRequetsLatency = (float)requestsDelta / (float)durationDelta;
            }
        }
        this.getMonitors().put("requests-throughput", Float.valueOf(requestsThroughput));
        this.getMonitors().put("average-requests-latency", Float.valueOf(averageRequetsLatency));
    }

    public long getTotal() {
        return (Long)this.getMonitors().get("total");
    }

    public long getActive() {
        return (Long)this.getMonitors().get("active");
    }

    public long getTotalDuration() {
        return (Long)this.getMonitors().get("duration-total");
    }

    public float getRequestsThroughput() {
        return ((Float)this.getMonitors().get("requests-throughput")).floatValue();
    }

    public float getAverageRequestsLatency() {
        return ((Float)this.getMonitors().get("average-requests-latency")).floatValue();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }

    public static class Attributes {
        public static final String TOTAL = "total";
        public static final String ACTIVE = "active";
        public static final String TOTAL_DURATION = "duration-total";
        public static final String REQUESTS_THROUGHPUT = "requests-throughput";
        public static final String AVERAGE_REQUESTS_LATENCY = "average-requests-latency";
    }
}

