/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.servicegrid;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.jini.core.lookup.ServiceID;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.properties.BeanLevelProperties;
import org.openspaces.core.space.SpaceServiceDetails;
import org.openspaces.core.space.SpaceType;
import org.openspaces.pu.service.ServiceDetails;

public class PUDetails
implements Externalizable {
    private static final long serialVersionUID = -6918314643571673741L;
    private ServiceID gscServiceID;
    private ClusterInfo clusterInfo;
    private BeanLevelProperties beanLevelProperties;
    private Object[] details;

    public PUDetails() {
    }

    public PUDetails(ServiceID gscServiceID, ClusterInfo clusterInfo, BeanLevelProperties beanLevelProperties, Object[] details) {
        this.gscServiceID = gscServiceID;
        this.clusterInfo = clusterInfo;
        this.beanLevelProperties = beanLevelProperties;
        this.details = details;
        if (details == null) {
            this.details = new ServiceDetails[0];
        }
    }

    public ServiceID getGscServiceID() {
        return this.gscServiceID;
    }

    public ClusterInfo getClusterInfo() {
        return this.clusterInfo;
    }

    public BeanLevelProperties getBeanLevelProperties() {
        return this.beanLevelProperties;
    }

    public Object[] getDetails() {
        return this.details;
    }

    public SpaceServiceDetails getEmbeddedSpaceServiceDetails() {
        return this.getServiceDetails(SpaceServiceDetails.class, sd -> sd.getSpaceType() == SpaceType.EMBEDDED);
    }

    public SpaceServiceDetails getEmbeddedSpaceServiceDetails(ServiceID serviceID) {
        return this.getServiceDetails(SpaceServiceDetails.class, sd -> sd.getSpaceType() == SpaceType.EMBEDDED && sd.getServiceID().equals((Object)serviceID));
    }

    public List<SpaceServiceDetails> getEmbeddedSpaceServiceDetailsList() {
        return this.getServiceDetailsList(SpaceServiceDetails.class, sd -> sd.getSpaceType() == SpaceType.EMBEDDED);
    }

    public <T> T getServiceDetails(Class<T> serviceType, Predicate<T> filter) {
        if (this.details != null) {
            for (Object detail : this.details) {
                if (!serviceType.isInstance(detail)) continue;
                T serviceDetails = serviceType.cast(detail);
                if (filter != null && !filter.test(serviceDetails)) continue;
                return serviceDetails;
            }
        }
        return null;
    }

    public <T> List<T> getServiceDetailsList(Class<T> serviceType, Predicate<T> filter) {
        ArrayList<T> result = new ArrayList<T>();
        if (this.details != null) {
            for (Object detail : this.details) {
                if (!serviceType.isInstance(detail)) continue;
                T serviceDetails = serviceType.cast(detail);
                if (filter != null && !filter.test(serviceDetails)) continue;
                result.add(serviceDetails);
            }
        }
        return result;
    }

    public String getPresentationName() {
        if (this.clusterInfo == null) {
            return "null";
        }
        Integer id = this.clusterInfo.getInstanceId();
        if (this.clusterInfo.getNumberOfBackups() == 0) {
            return this.clusterInfo.getName() + " [" + id + "]";
        }
        Integer bid = this.clusterInfo.getBackupId();
        if (bid == null) {
            bid = 0;
        }
        return this.clusterInfo.getName() + "." + id + " [" + (bid + 1) + "]";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.gscServiceID);
        out.writeObject(this.clusterInfo);
        out.writeInt(this.details.length);
        for (Object details : this.details) {
            out.writeObject(details);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.gscServiceID = (ServiceID)in.readObject();
        this.clusterInfo = (ClusterInfo)in.readObject();
        int size = in.readInt();
        this.details = new ServiceDetails[size];
        for (int i = 0; i < size; ++i) {
            this.details[i] = in.readObject();
        }
    }
}

