/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.spi;

import com.gigaspaces.internal.dump.InternalDumpProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.openspaces.admin.quiesce.QuiesceStateChangedListener;
import org.openspaces.core.cluster.MemberAliveIndicator;
import org.openspaces.core.cluster.ProcessingUnitUndeployingListener;
import org.openspaces.pu.container.ProcessingUnitContainer;
import org.openspaces.pu.service.InvocableService;
import org.openspaces.pu.service.ServiceDetailsProvider;
import org.openspaces.pu.service.ServiceMonitorsProvider;
import org.springframework.context.ApplicationContext;

public abstract class ApplicationContextProcessingUnitContainer
extends ProcessingUnitContainer {
    public abstract ApplicationContext getApplicationContext();

    @Override
    public Collection<ServiceDetailsProvider> getServiceDetailsProviders() {
        return this.getBeansOfType(ServiceDetailsProvider.class).values();
    }

    @Override
    public Collection<ServiceMonitorsProvider> getServiceMonitorsProviders() {
        return this.getBeansOfType(ServiceMonitorsProvider.class).values();
    }

    @Override
    public Collection<QuiesceStateChangedListener> getQuiesceStateChangedListeners() {
        return this.getBeansOfType(QuiesceStateChangedListener.class).values();
    }

    @Override
    public Collection<ProcessingUnitUndeployingListener> getUndeployListeners() {
        return this.getBeansOfType(ProcessingUnitUndeployingListener.class).values();
    }

    @Override
    public Collection<MemberAliveIndicator> getMemberAliveIndicators() {
        return this.getBeansOfType(MemberAliveIndicator.class).values();
    }

    @Override
    public Collection<InternalDumpProcessor> getDumpProcessors() {
        return this.getBeansOfType(InternalDumpProcessor.class).values();
    }

    @Override
    public Map<String, InvocableService> getInvocableServices() {
        return this.getBeansOfType(InvocableService.class);
    }

    private <T> Map<String, T> getBeansOfType(Class<T> type) {
        ApplicationContext applicationContext = this.getApplicationContext();
        return applicationContext != null ? applicationContext.getBeansOfType(type) : Collections.EMPTY_MAP;
    }
}

