/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.standalone;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.properties.BeanLevelProperties;
import org.openspaces.pu.container.CannotCreateContainerException;
import org.openspaces.pu.container.ProcessingUnitContainerConfig;
import org.openspaces.pu.container.support.ResourceApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class StandaloneContainerRunnable
implements Runnable {
    private final ProcessingUnitContainerConfig config = new ProcessingUnitContainerConfig();
    private List<String> configLocations;
    private volatile boolean running;
    private volatile boolean initialized;
    private ResourceApplicationContext applicationContext;
    private volatile Throwable exception;
    private volatile Thread runningThread;

    public StandaloneContainerRunnable(BeanLevelProperties beanLevelProperties, ClusterInfo clusterInfo, List<String> configLocations) {
        this.config.setBeanLevelProperties(beanLevelProperties);
        this.config.setClusterInfo(clusterInfo);
        this.configLocations = configLocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Resource[] resources;
            block16: {
                this.runningThread = Thread.currentThread();
                PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();
                if (this.configLocations.size() == 0) {
                    try {
                        resources = pathMatchingResourcePatternResolver.getResources("classpath*:/META-INF/spring/pu.xml");
                        if (resources.length == 0) {
                            throw new CannotCreateContainerException("Failed to find classpath*:/META-INF/spring/pu.xml");
                        }
                        break block16;
                    }
                    catch (IOException e) {
                        throw new CannotCreateContainerException("Failed to parse pu.xml", e);
                    }
                }
                ArrayList<Resource> tempResourcesList = new ArrayList<Resource>();
                for (String configLocation : this.configLocations) {
                    try {
                        Resource[] tempResources;
                        for (Resource tempResource : tempResources = pathMatchingResourcePatternResolver.getResources(configLocation)) {
                            tempResourcesList.add(tempResource);
                        }
                    }
                    catch (IOException e) {
                        throw new CannotCreateContainerException("Failed to parse pu.xml from location [" + configLocation + "]", e);
                    }
                }
                resources = tempResourcesList.toArray(new Resource[tempResourcesList.size()]);
            }
            this.applicationContext = new ResourceApplicationContext(resources, null, this.config);
            this.applicationContext.refresh();
            this.running = true;
        }
        catch (Throwable t) {
            this.exception = t;
            return;
        }
        finally {
            this.initialized = true;
        }
        while (this.isRunning() && !Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.applicationContext.destroy();
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void stop() {
        this.running = false;
        if (this.runningThread != null) {
            this.runningThread.interrupt();
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public synchronized boolean hasException() {
        return this.exception != null;
    }

    public synchronized Throwable getException() {
        return this.exception;
    }
}

