/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.standalone;

import com.gigaspaces.admin.cli.RuntimeInfo;
import com.gigaspaces.logger.GSLogConfigLoader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.pu.container.CannotCloseContainerException;
import org.openspaces.pu.container.ProcessingUnitContainer;
import org.openspaces.pu.container.spi.ApplicationContextProcessingUnitContainer;
import org.openspaces.pu.container.standalone.StandaloneContainerRunnable;
import org.openspaces.pu.container.standalone.StandaloneProcessingUnitContainerProvider;
import org.openspaces.pu.container.support.BeanLevelPropertiesParser;
import org.openspaces.pu.container.support.ClusterInfoParser;
import org.openspaces.pu.container.support.CommandLineParser;
import org.openspaces.pu.container.support.ConfigLocationParser;
import org.openspaces.pu.container.support.ProcessingUnitPathParser;
import org.springframework.context.ApplicationContext;

public class StandaloneProcessingUnitContainer
extends ApplicationContextProcessingUnitContainer {
    private static final Log logger = LogFactory.getLog(StandaloneProcessingUnitContainer.class);
    private StandaloneContainerRunnable containerRunnable;

    public StandaloneProcessingUnitContainer(StandaloneContainerRunnable containerRunnable) {
        this.containerRunnable = containerRunnable;
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.containerRunnable.getApplicationContext();
    }

    @Override
    public void close() throws CannotCloseContainerException {
        this.containerRunnable.stop();
        super.close();
    }

    public static void main(String[] args) throws Exception {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        if (!(currentClassLoader instanceof URLClassLoader)) {
            URLClassLoader urlClassLoader = new URLClassLoader(new URL[0], currentClassLoader);
            Thread.currentThread().setContextClassLoader(urlClassLoader);
        }
        GSLogConfigLoader.getLoader();
        StandaloneProcessingUnitContainer.showUsageOptionsOnHelpCommand(args);
        if (args.length == 0) {
            StandaloneProcessingUnitContainer.printUsage();
            System.exit(1);
        }
        logger.info((Object)("Starting with args: " + Arrays.toString(args) + "\n" + RuntimeInfo.getEnvironmentInfoIfFirstTime()));
        try {
            final ProcessingUnitContainer container = StandaloneProcessingUnitContainer.createContainer(args);
            logger.info((Object)"Started successfully");
            final Thread mainThread = Thread.currentThread();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        logger.info((Object)"Shutdown hook triggered");
                        container.close();
                        logger.info((Object)"Shutdown complete");
                    }
                    finally {
                        mainThread.interrupt();
                    }
                }
            });
            while (!mainThread.isInterrupted()) {
                try {
                    Thread.sleep(Long.MAX_VALUE);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception e) {
            StandaloneProcessingUnitContainer.printUsage();
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private static void showUsageOptionsOnHelpCommand(String[] args) {
        for (String arg : args) {
            if (!arg.equals("--help")) continue;
            StandaloneProcessingUnitContainer.printUsage();
            System.exit(0);
        }
    }

    public static ProcessingUnitContainer createContainer(String[] args) throws Exception {
        CommandLineParser.Parameter[] params = CommandLineParser.parse(args);
        StandaloneProcessingUnitContainerProvider provider = new StandaloneProcessingUnitContainerProvider(ProcessingUnitPathParser.parse(params));
        provider.setBeanLevelProperties(BeanLevelPropertiesParser.parse(params));
        provider.setClusterInfo(ClusterInfoParser.parse(params));
        ConfigLocationParser.parse(provider, params);
        return provider.createContainer();
    }

    public static void printUsage() {
        System.out.println("usage options: [-path ...] [-cluster ...] [-properties ...]");
        System.out.println();
        System.out.println("    --help                                    : Shows this usage options menu");
        System.out.println();
        System.out.println("    -path [processing unit path]   (required) : The relative/absolute path of a processing unit directory or jar");
        System.out.println("    -cluster [cluster properties]             : Allows specify cluster parameters");
        System.out.println("             schema=partitioned               : The cluster schema to use (default is partitioned)");
        System.out.println("             total_members=1,1                : The number of instances and number of backups to use");
        System.out.println("             id=1                             : The instance id of this processing unit");
        System.out.println("             backup_id=1                      : The backup id of this processing unit");
        System.out.println("    -properties [properties-loc]              : Location of context level properties");
        System.out.println("    -properties [bean-name] [properties-loc]  : Location of properties used applied only for a specified bean");
        System.out.println();
        System.out.println();
        System.out.println("Processing Unit directory structure:");
        System.out.println("~/my-processing-unit/");
        System.out.println("  |- META-INF/ MANIFEST.MF                       (*)");
        System.out.println("  |            spring/ pu.xml");
        System.out.println("  |                    pu.properties             (*)");
        System.out.println("  |                    sla.xml                   (*)");
        System.out.println("  |- com/mycompany/myproject/ MyClass1.class");
        System.out.println("  |-                          MyClass2.class");
        System.out.println("  |- lib/ dependency1.jar                        (*)");
        System.out.println("  |-      dependency2.jar                        (*)");
        System.out.println();
        System.out.println(" (*) files that are optional");
        System.out.println();
        System.out.println("Some Examples:");
        System.out.println();
        System.out.println("1. -path ~/my-processing-unit/");
        System.out.println("    > Start a processing unit specified by a path to a processing unit directory structure");
        System.out.println();
        System.out.println("2. -path ~/my-processing-unit/target/my-processing-unit.jar");
        System.out.println("    > Starts a processing unit packaged as a jar file (assembled with a processing unit directory structure)");
        System.out.println();
        System.out.println("3. -path ~/my-processing-unit/ -cluster schema=partitioned total_members=2,1");
        System.out.println("    > Starts a processing unit with a partitioned cluster schema of two members (with one backup each) all in one process");
        System.out.println();
        System.out.println("4. -path ~/my-processing-unit/ -cluster schema=partitioned total_members=2,1 id=1");
        System.out.println("    > Starts only the first instance (id=1) of a processing unit belonging to a 2,1 partitioned cluster (two members with one backup each)");
        System.out.println();
        System.out.println("5. -path ~/my-processing-unit/ -cluster schema=partitioned total_members=2,1 id=1 backup_id=1");
        System.out.println("    > Starts only the backup of the first instance (id=1) of a processing unit belonging to a 2,1 partitioned cluster (two members with one backup each)");
        System.out.println();
        System.out.println("6. -path ~/my-processing-unit/ -properties file://config/context.properties -properties space1 file://config/space1.properties");
        System.out.println("    > Starts a processing unit using context level properties (context.properties) and bean level properties (space1.properties) applied to bean named space1");
        System.out.println();
        System.out.println("7. -path ~/my-processing-unit/ -properties embed://prop1=value1 -properties space1 embed://prop2=value2;prop3=value3");
        System.out.println("    > Starts a processing unit using context level properties with a single property called prop1 with value1 and bean level properties with two properties");
        System.out.println();
    }
}

