/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.standalone;

import com.gigaspaces.internal.io.BootIOUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.pu.container.CannotCreateContainerException;
import org.openspaces.pu.container.ProcessingUnitContainer;
import org.openspaces.pu.container.spi.ApplicationContextProcessingUnitContainerProvider;
import org.openspaces.pu.container.standalone.StandaloneContainerRunnable;
import org.openspaces.pu.container.standalone.StandaloneProcessingUnitContainer;
import org.openspaces.pu.container.support.ClusterInfoParser;
import org.openspaces.pu.container.support.CompoundProcessingUnitContainer;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;

public class StandaloneProcessingUnitContainerProvider
extends ApplicationContextProcessingUnitContainerProvider {
    private static Log logger = LogFactory.getLog(StandaloneProcessingUnitContainerProvider.class);
    private String location;
    private List<String> configLocations = new ArrayList<String>();
    private boolean addedSharedLibToClassLoader = false;

    public StandaloneProcessingUnitContainerProvider(String location) {
        this.location = location;
    }

    @Override
    public void addConfigLocation(String configLocation) {
        this.configLocations.add(configLocation);
    }

    @Override
    public void addConfigLocation(Resource resource) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProcessingUnitContainer createContainer() throws CannotCreateContainerException {
        File fileLocation = new File(this.location);
        if (!fileLocation.exists()) {
            throw new CannotCreateContainerException("Failed to locate pu location [" + this.location + "]");
        }
        ClusterInfo clusterInfo = this.getClusterInfo();
        if (clusterInfo != null && clusterInfo.getInstanceId() == null) {
            ClusterInfo origClusterInfo = clusterInfo;
            ArrayList<ProcessingUnitContainer> containers = new ArrayList<ProcessingUnitContainer>();
            for (int i = 0; i < clusterInfo.getNumberOfInstances(); ++i) {
                ClusterInfo containerClusterInfo = clusterInfo.copy();
                containerClusterInfo.setInstanceId(i + 1);
                containerClusterInfo.setBackupId(null);
                this.setClusterInfo(containerClusterInfo);
                containers.add(this.createContainer());
                if (clusterInfo.getNumberOfBackups() == null) continue;
                for (int j = 0; j < clusterInfo.getNumberOfBackups(); ++j) {
                    containerClusterInfo = containerClusterInfo.copy();
                    containerClusterInfo.setBackupId(j + 1);
                    this.setClusterInfo(containerClusterInfo);
                    containers.add(this.createContainer());
                }
            }
            this.setClusterInfo(origClusterInfo);
            return new CompoundProcessingUnitContainer(containers.toArray(new ProcessingUnitContainer[containers.size()]));
        }
        if (clusterInfo != null) {
            ClusterInfoParser.guessSchema(clusterInfo);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Starting a Standalone processing unit container " + (clusterInfo != null ? "with " + clusterInfo : "")));
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        ArrayList<URL> sharedUrls = new ArrayList<URL>();
        if (fileLocation.isDirectory()) {
            if (fileLocation.exists()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Adding pu directory location [" + this.location + "] to classpath"));
                }
                try {
                    urls.add(fileLocation.toURL());
                }
                catch (MalformedURLException e) {
                    throw new CannotCreateContainerException("Failed to add classes to class loader with location [" + this.location + "]", e);
                }
            }
            this.addJarsLocation(fileLocation, urls, "lib");
            this.addJarsLocation(fileLocation, sharedUrls, "shared-lib");
        } else {
            JarFile jarFile;
            try {
                jarFile = new JarFile(fileLocation);
            }
            catch (IOException e) {
                throw new CannotCreateContainerException("Failed to open pu file [" + this.location + "]", e);
            }
            try {
                urls.add(new URL("jar:" + fileLocation.toURL() + "!/"));
            }
            catch (MalformedURLException e) {
                throw new CannotCreateContainerException("Failed to add pu location [" + this.location + "] to classpath", e);
            }
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                FileOutputStream fos;
                File tempJar;
                JarEntry jarEntry = entries.nextElement();
                if (!this.isWithinDir(jarEntry, "lib") && !this.isWithinDir(jarEntry, "shared-lib")) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Adding jar [" + jarEntry.getName() + "] with pu location [" + this.location + "]"));
                }
                File tempLocation = new File(System.getProperty("java.io.tmpdir") + "/openspaces");
                tempLocation.mkdirs();
                String tempJarName = jarEntry.getName();
                if (tempJarName.indexOf(47) != -1) {
                    tempJarName = tempJarName.substring(tempJarName.lastIndexOf(47) + 1);
                }
                try {
                    tempJar = File.createTempFile(tempJarName, ".jar", tempLocation);
                }
                catch (IOException e) {
                    throw new CannotCreateContainerException("Failed to create temp jar at location [" + tempLocation + "] with name [" + tempJarName + "]", e);
                }
                tempJar.deleteOnExit();
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Extracting jar [" + jarEntry.getName() + "] to temporary jar [" + tempJar.getAbsolutePath() + "]"));
                }
                try {
                    fos = new FileOutputStream(tempJar);
                }
                catch (FileNotFoundException e) {
                    throw new CannotCreateContainerException("Failed to find temp jar [" + tempJar.getAbsolutePath() + "]", e);
                }
                InputStream is = null;
                try {
                    is = jarFile.getInputStream(jarEntry);
                    FileCopyUtils.copy((InputStream)is, (OutputStream)fos);
                }
                catch (IOException e) {
                    throw new CannotCreateContainerException("Failed to create temp jar [" + tempJar.getAbsolutePath() + "]");
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
                try {
                    if (this.isWithinDir(jarEntry, "lib")) {
                        urls.add(tempJar.toURL());
                        continue;
                    }
                    if (!this.isWithinDir(jarEntry, "shared-lib")) continue;
                    sharedUrls.add(tempJar.toURL());
                }
                catch (MalformedURLException e) {
                    throw new CannotCreateContainerException("Failed to add pu entry [" + jarEntry.getName() + "] with location [" + this.location + "]", e);
                }
            }
        }
        ArrayList<URL> allUrls = new ArrayList<URL>();
        allUrls.addAll(sharedUrls);
        allUrls.addAll(urls);
        this.addUrlsToContextClassLoader(allUrls.toArray(new URL[allUrls.size()]));
        StandaloneContainerRunnable containerRunnable = new StandaloneContainerRunnable(this.getBeanLevelProperties(), clusterInfo, this.configLocations);
        Thread standaloneContainerThread = new Thread((Runnable)containerRunnable, "Standalone Container Thread");
        standaloneContainerThread.setDaemon(false);
        standaloneContainerThread.start();
        while (!containerRunnable.isInitialized()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                logger.warn((Object)"Interrupted while waiting for standalone container to initialize");
            }
        }
        if (containerRunnable.hasException()) {
            throw new CannotCreateContainerException("Failed to start container", containerRunnable.getException());
        }
        return new StandaloneProcessingUnitContainer(containerRunnable);
    }

    private boolean isWithinDir(JarEntry jarEntry, String dir) {
        return jarEntry.getName().startsWith(dir + "/") && jarEntry.getName().length() > (dir + "/").length();
    }

    private void addJarsLocation(File fileLocation, List<URL> urls, String dir) {
        File libLocation = new File(fileLocation, dir);
        if (libLocation.exists()) {
            File[] jarFiles;
            for (File jarFile : jarFiles = BootIOUtils.listFiles((File)libLocation)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Adding jar [" + jarFile.getAbsolutePath() + "] with pu directory location [" + this.location + "] to classpath"));
                }
                try {
                    urls.add(jarFile.toURL());
                }
                catch (MalformedURLException e) {
                    throw new CannotCreateContainerException("Failed to add jar file [" + jarFile.getAbsolutePath() + "] to classs loader", e);
                }
            }
        }
    }

    private void addUrlsToContextClassLoader(URL[] urls) {
        Class<?> clazz;
        if (this.addedSharedLibToClassLoader) {
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (clazz = classLoader.getClass(); clazz != Object.class && !URLClassLoader.class.equals(clazz); clazz = clazz.getSuperclass()) {
        }
        if (clazz == Object.class) {
            throw new CannotCreateContainerException("Failed to find URLClassLoader to add shared lib for " + classLoader.getClass());
        }
        try {
            Method addURL = clazz.getDeclaredMethod("addURL", URL.class);
            addURL.setAccessible(true);
            for (URL url : urls) {
                addURL.invoke((Object)classLoader, url);
            }
        }
        catch (Exception e) {
            throw new CannotCreateContainerException("Failed to add shared lib to thread context class loader [" + classLoader + "]", e);
        }
        this.addedSharedLibToClassLoader = true;
    }
}

