/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.support;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.openspaces.core.properties.BeanLevelProperties;
import org.openspaces.pu.container.support.CommandLineParser;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public abstract class BeanLevelPropertiesParser {
    public static final String EMBEDDED_PROPERTIES_PREFIX = "embed://";
    public static final String DEFAULT_CONTEXT_PROPERTIES_LOCATION = "META-INF/spring/pu.properties";

    public static BeanLevelProperties parse(CommandLineParser.Parameter[] params) throws IllegalArgumentException {
        return BeanLevelPropertiesParser.parse(new BeanLevelProperties(), params);
    }

    public static BeanLevelProperties parse(BeanLevelProperties beanLevelProperties, CommandLineParser.Parameter[] params) throws IllegalArgumentException {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(DEFAULT_CONTEXT_PROPERTIES_LOCATION);
        if (is != null) {
            try {
                beanLevelProperties.getContextProperties().load(is);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to load [META-INF/spring/pu.properties]", e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        for (CommandLineParser.Parameter param : params) {
            String properties;
            if (!param.getName().equalsIgnoreCase("properties")) continue;
            String name = null;
            if (param.getArguments().length == 1) {
                properties = param.getArguments()[0];
            } else if (param.getArguments().length == 2) {
                name = param.getArguments()[0];
                properties = param.getArguments()[1];
            } else {
                throw new IllegalArgumentException("-properties can accept only one or two values, not more and not less");
            }
            Properties props = new Properties();
            if (properties.startsWith(EMBEDDED_PROPERTIES_PREFIX)) {
                BeanLevelPropertiesParser.loadParams(properties, props);
            } else {
                Resource resource = new DefaultResourceLoader(){

                    protected Resource getResourceByPath(String path) {
                        return new FileSystemResource(path);
                    }
                }.getResource(properties);
                try {
                    is = resource.getInputStream();
                    props.load(is);
                    is.close();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to load resource [" + properties + "] " + e.getMessage());
                }
            }
            if (name == null) {
                beanLevelProperties.getContextProperties().putAll((Map<?, ?>)props);
                continue;
            }
            if (beanLevelProperties.hasBeanProperties(name)) {
                beanLevelProperties.getBeanProperties(name).putAll((Map<?, ?>)props);
                continue;
            }
            beanLevelProperties.setBeanProperties(name, props);
        }
        return beanLevelProperties;
    }

    public static void loadParams(String properties, Map props) {
        properties = properties.substring(EMBEDDED_PROPERTIES_PREFIX.length());
        StringTokenizer tokenizer = new StringTokenizer(properties, ";");
        while (tokenizer.hasMoreTokens()) {
            String property = tokenizer.nextToken();
            int equalsIndex = property.indexOf(61);
            if (equalsIndex == -1) {
                props.put(property, "");
                continue;
            }
            props.put(property.substring(0, equalsIndex), property.substring(equalsIndex + 1));
        }
    }
}

