/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.core.properties.BeanLevelProperties;
import org.springframework.util.FileCopyUtils;

public abstract class BeanLevelPropertiesUtils {
    private static final Log logger = LogFactory.getLog(BeanLevelPropertiesUtils.class);
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final String PLACEHOLDER_SUFFIX = "}";

    public static void resolvePlaceholders(BeanLevelProperties beanLevelProperties, File input) throws IOException {
        if (!input.exists()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Replacing file [" + input.getAbsolutePath() + "] with properties [" + beanLevelProperties.getContextProperties() + "]"));
        }
        String content = FileCopyUtils.copyToString((Reader)new InputStreamReader((InputStream)new FileInputStream(input), "UTF-8"));
        File renameTo = new File(input.getAbsolutePath() + ".replace");
        boolean success = false;
        for (int i = 0; i < 10; ++i) {
            if (!input.renameTo(renameTo)) continue;
            success = true;
            break;
        }
        if (!success) {
            throw new IOException("Failed to rename [" + input.getAbsolutePath() + "] in order to replace it");
        }
        FileCopyUtils.copy((String)BeanLevelPropertiesUtils.resolvePlaceholders(content, beanLevelProperties), (Writer)new OutputStreamWriter(new FileOutputStream(input)));
        renameTo.delete();
    }

    public static String resolvePlaceholders(String text, BeanLevelProperties beanLevelProperties) {
        StringBuilder buf = new StringBuilder(text);
        int startIndex = buf.indexOf(PLACEHOLDER_PREFIX);
        while (startIndex != -1) {
            int endIndex = buf.indexOf(PLACEHOLDER_SUFFIX, startIndex + PLACEHOLDER_PREFIX.length());
            if (endIndex != -1) {
                int nextIndex;
                block6: {
                    String placeholder = buf.substring(startIndex + PLACEHOLDER_PREFIX.length(), endIndex);
                    nextIndex = endIndex + PLACEHOLDER_SUFFIX.length();
                    try {
                        String propVal = beanLevelProperties.getContextProperties().getProperty(placeholder);
                        if (propVal == null && (propVal = System.getProperty(placeholder)) == null) {
                            propVal = System.getenv(placeholder);
                        }
                        if (propVal != null) {
                            buf.replace(startIndex, endIndex + PLACEHOLDER_SUFFIX.length(), propVal);
                            nextIndex = startIndex + propVal.length();
                        }
                    }
                    catch (Throwable ex) {
                        if (!logger.isWarnEnabled()) break block6;
                        logger.warn((Object)("Could not resolve placeholder '" + placeholder + "' in [" + text + "] as system property: " + ex));
                    }
                }
                startIndex = buf.indexOf(PLACEHOLDER_PREFIX, nextIndex);
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }
}

