/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.support;

import com.j_spaces.core.client.SpaceURL;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.pu.container.support.CommandLineParser;

public abstract class ClusterInfoParser {
    public static final String CLUSTER_PARAMETER_TOTALMEMBERS = "total_members";
    public static final String CLUSTER_PARAMETER_INSTANCEID = "id";
    public static final String CLUSTER_PARAMETER_BACKUPID = "backup_id";
    public static final String CLUSTER_PARAMETER_CLUSTERSCHEMA = "schema";

    public static ClusterInfo parse(CommandLineParser.Parameter[] params) throws IllegalArgumentException {
        ClusterInfo clusterInfo = null;
        for (CommandLineParser.Parameter param : params) {
            if (!param.getName().equalsIgnoreCase("cluster")) continue;
            if (clusterInfo == null) {
                clusterInfo = new ClusterInfo();
            }
            if (param.getArguments().length == 0) {
                throw new IllegalArgumentException("cluster parameter should have at least one parameter");
            }
            for (int j = 0; j < param.getArguments().length; ++j) {
                String clusterParameter = param.getArguments()[j];
                int equalsIndex = clusterParameter.indexOf("=");
                if (equalsIndex == -1) {
                    throw new IllegalArgumentException("Cluster parameter [" + clusterParameter + "] is malformed, must have a name=value syntax");
                }
                String clusterParamName = clusterParameter.substring(0, equalsIndex);
                String clusterParamValue = clusterParameter.substring(equalsIndex + 1);
                if (CLUSTER_PARAMETER_TOTALMEMBERS.equalsIgnoreCase(clusterParamName)) {
                    int commaIndex = clusterParamValue.indexOf(44);
                    if (commaIndex == -1) {
                        clusterInfo.setNumberOfInstances(Integer.valueOf(clusterParamValue));
                        continue;
                    }
                    String numberOfInstances = clusterParamValue.substring(0, commaIndex);
                    String numberOfBackups = clusterParamValue.substring(commaIndex + 1);
                    clusterInfo.setNumberOfInstances(Integer.valueOf(numberOfInstances));
                    clusterInfo.setNumberOfBackups(Integer.valueOf(numberOfBackups));
                    continue;
                }
                if (CLUSTER_PARAMETER_INSTANCEID.equalsIgnoreCase(clusterParamName)) {
                    clusterInfo.setInstanceId(Integer.valueOf(clusterParamValue));
                    continue;
                }
                if (CLUSTER_PARAMETER_BACKUPID.equalsIgnoreCase(clusterParamName)) {
                    clusterInfo.setBackupId(Integer.valueOf(clusterParamValue));
                    continue;
                }
                if (CLUSTER_PARAMETER_CLUSTERSCHEMA.equalsIgnoreCase(clusterParamName)) {
                    clusterInfo.setSchema(clusterParamValue);
                    continue;
                }
                throw new IllegalArgumentException("deploy parameter property name [" + clusterParamName + "] is invalid");
            }
        }
        if (clusterInfo != null && clusterInfo.getNumberOfInstances() == null) {
            throw new IllegalArgumentException("unspecified cluster total number of instances");
        }
        return clusterInfo;
    }

    public static ClusterInfo parse(SpaceURL spaceURL) {
        ClusterInfo clusterInfo = new ClusterInfo();
        clusterInfo.setSchema(spaceURL.getProperty("cluster_schema"));
        clusterInfo.setInstanceId(ClusterInfoParser.parseInt(spaceURL.getProperty(CLUSTER_PARAMETER_INSTANCEID), 1));
        clusterInfo.setBackupId(ClusterInfoParser.parseInt(spaceURL.getProperty(CLUSTER_PARAMETER_BACKUPID), null));
        String s = spaceURL.getProperty(CLUSTER_PARAMETER_TOTALMEMBERS);
        String[] tokens = (s != null && s.length() != 0 ? s : "1,0").split(",");
        clusterInfo.setNumberOfInstances(Integer.parseInt(tokens[0]));
        clusterInfo.setNumberOfBackups(tokens.length > 1 ? Integer.parseInt(tokens[1]) : 0);
        return clusterInfo;
    }

    private static Integer parseInt(String s, Integer defaultValue) {
        return s == null || s.length() == 0 ? defaultValue : Integer.valueOf(s);
    }

    public static void guessSchema(ClusterInfo clusterInfo) {
        if (clusterInfo.getSchema() != null) {
            return;
        }
        if (clusterInfo.getNumberOfInstances() != null && clusterInfo.getNumberOfInstances() > 1) {
            clusterInfo.setSchema("partitioned");
        } else if (clusterInfo.getNumberOfInstances() != null && clusterInfo.getNumberOfInstances() == 1 && clusterInfo.getNumberOfBackups() != null && clusterInfo.getNumberOfBackups() > 0) {
            clusterInfo.setSchema("partitioned");
        }
    }
}

