/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class CommandLineParser {
    public static Parameter[] parse(String[] args) throws IllegalArgumentException {
        return CommandLineParser.parse(args, new HashSet<String>(0));
    }

    public static Parameter[] parse(String[] args, Set<String> parametersWithoutValues) throws IllegalArgumentException {
        return CommandLineParser.parse(args, args.length, parametersWithoutValues);
    }

    public static Parameter[] parse(String[] args, int length) throws IllegalArgumentException {
        return CommandLineParser.parse(args, length, new HashSet<String>());
    }

    private static Parameter[] parse(String[] args, int length, Set<String> parametersWithoutValues) throws IllegalArgumentException {
        if (length == 0) {
            return new Parameter[0];
        }
        if (length == 1 && !parametersWithoutValues.contains(args[0])) {
            throw new IllegalArgumentException("Command line structure is incorrect, only one parameter");
        }
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        int index = 0;
        while (index < length) {
            boolean shouldHaveValue;
            if (!args[index].startsWith("-")) {
                throw new IllegalArgumentException("Command line argument [" + args[index] + "] is supposed to start with -");
            }
            boolean bl = shouldHaveValue = !parametersWithoutValues.contains(args[index]);
            if (index + 1 == length && shouldHaveValue) {
                throw new IllegalArgumentException("Command line argument [" + args[index] + "] has no argument");
            }
            List<String> arguments = new ArrayList();
            String name = args[index].substring(1, args[index].length());
            ++index;
            if (shouldHaveValue) {
                while (index < length && !args[index].startsWith("-")) {
                    arguments.add(args[index]);
                    ++index;
                }
            } else {
                arguments = Collections.EMPTY_LIST;
            }
            Parameter parameter = new Parameter(name, arguments.toArray(new String[arguments.size()]));
            params.add(parameter);
        }
        return params.toArray(new Parameter[params.size()]);
    }

    public static class Parameter {
        private String name;
        private String[] arguments;

        public Parameter(String name, String[] arguments) {
            this.name = name;
            this.arguments = arguments;
        }

        public String getName() {
            return this.name;
        }

        public String[] getArguments() {
            return this.arguments;
        }
    }
}

