/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.support;

import com.gigaspaces.internal.dump.InternalDumpProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openspaces.admin.quiesce.QuiesceStateChangedListener;
import org.openspaces.core.cluster.MemberAliveIndicator;
import org.openspaces.core.cluster.ProcessingUnitUndeployingListener;
import org.openspaces.pu.container.CannotCloseContainerException;
import org.openspaces.pu.container.ProcessingUnitContainer;
import org.openspaces.pu.service.InvocableService;
import org.openspaces.pu.service.ServiceDetailsProvider;
import org.openspaces.pu.service.ServiceMonitorsProvider;

public class CompoundProcessingUnitContainer
extends ProcessingUnitContainer {
    private final ProcessingUnitContainer[] containers;

    public CompoundProcessingUnitContainer(ProcessingUnitContainer[] containers) {
        this.containers = containers;
    }

    public ProcessingUnitContainer[] getProcessingUnitContainers() {
        return this.containers;
    }

    @Override
    public void close() throws CannotCloseContainerException {
        for (ProcessingUnitContainer container : this.containers) {
            container.close();
        }
        super.close();
    }

    @Override
    public Collection<ServiceDetailsProvider> getServiceDetailsProviders() {
        ArrayList<ServiceDetailsProvider> result = Collections.EMPTY_LIST;
        for (ProcessingUnitContainer container : this.containers) {
            Collection<ServiceDetailsProvider> providers = container.getServiceDetailsProviders();
            if (providers.isEmpty()) continue;
            if (result.isEmpty()) {
                result = new ArrayList<ServiceDetailsProvider>();
            }
            result.addAll(providers);
        }
        return result;
    }

    @Override
    public Collection<ServiceMonitorsProvider> getServiceMonitorsProviders() {
        ArrayList<ServiceMonitorsProvider> result = Collections.EMPTY_LIST;
        for (ProcessingUnitContainer container : this.containers) {
            Collection<ServiceMonitorsProvider> providers = container.getServiceMonitorsProviders();
            if (providers.isEmpty()) continue;
            if (result.isEmpty()) {
                result = new ArrayList<ServiceMonitorsProvider>();
            }
            result.addAll(providers);
        }
        return result;
    }

    @Override
    public Collection<QuiesceStateChangedListener> getQuiesceStateChangedListeners() {
        ArrayList<QuiesceStateChangedListener> result = Collections.EMPTY_LIST;
        for (ProcessingUnitContainer container : this.containers) {
            Collection<QuiesceStateChangedListener> listeners = container.getQuiesceStateChangedListeners();
            if (listeners.isEmpty()) continue;
            if (result.isEmpty()) {
                result = new ArrayList<QuiesceStateChangedListener>();
            }
            result.addAll(listeners);
        }
        return result;
    }

    @Override
    public Collection<ProcessingUnitUndeployingListener> getUndeployListeners() {
        ArrayList<ProcessingUnitUndeployingListener> result = Collections.EMPTY_LIST;
        for (ProcessingUnitContainer container : this.containers) {
            Collection<ProcessingUnitUndeployingListener> listeners = container.getUndeployListeners();
            if (listeners.isEmpty()) continue;
            if (result.isEmpty()) {
                result = new ArrayList<ProcessingUnitUndeployingListener>();
            }
            result.addAll(listeners);
        }
        return result;
    }

    @Override
    public Collection<MemberAliveIndicator> getMemberAliveIndicators() {
        ArrayList<MemberAliveIndicator> result = Collections.EMPTY_LIST;
        for (ProcessingUnitContainer container : this.containers) {
            Collection<MemberAliveIndicator> indicators = container.getMemberAliveIndicators();
            if (indicators.isEmpty()) continue;
            if (result.isEmpty()) {
                result = new ArrayList<MemberAliveIndicator>();
            }
            result.addAll(indicators);
        }
        return result;
    }

    @Override
    public Collection<InternalDumpProcessor> getDumpProcessors() {
        ArrayList<InternalDumpProcessor> result = Collections.EMPTY_LIST;
        for (ProcessingUnitContainer container : this.containers) {
            Collection<InternalDumpProcessor> processors = container.getDumpProcessors();
            if (processors.isEmpty()) continue;
            if (result.isEmpty()) {
                result = new ArrayList<InternalDumpProcessor>();
            }
            result.addAll(processors);
        }
        return result;
    }

    @Override
    public Map<String, InvocableService> getInvocableServices() {
        HashMap<String, InvocableService> result = Collections.EMPTY_MAP;
        for (ProcessingUnitContainer container : this.containers) {
            Map<String, InvocableService> services = container.getInvocableServices();
            if (services.isEmpty()) continue;
            if (result.isEmpty()) {
                result = new HashMap<String, InvocableService>();
            }
            result.putAll(services);
        }
        return result;
    }
}

