/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.support;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jini.rio.boot.ServiceClassLoader;
import org.openspaces.pu.container.support.WebsterFile;
import org.openspaces.pu.container.support.WebsterResoruce;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class PUPathMatchingResourcePatternResolver
extends PathMatchingResourcePatternResolver {
    protected Resource convertClassLoaderURL(URL url) {
        if (!(this.getClassLoader() instanceof ServiceClassLoader)) {
            return super.convertClassLoaderURL(url);
        }
        if (url.getProtocol().equals("http") && url.toExternalForm().endsWith("/")) {
            return new WebsterResoruce(url);
        }
        return new UrlResource(url);
    }

    protected Set doFindMatchingFileSystemResources(File rootDir, String subPattern) throws IOException {
        Set result = super.doFindMatchingFileSystemResources(rootDir, subPattern);
        LinkedHashSet<Object> actualResult = new LinkedHashSet<Object>();
        for (Object val : result) {
            if (!(val instanceof FileSystemResource)) continue;
            FileSystemResource fsResource = (FileSystemResource)val;
            if (fsResource.getFile() instanceof WebsterFile) {
                WebsterFile websterFile = (WebsterFile)fsResource.getFile();
                actualResult.add(new UrlResource(websterFile.toURL()));
                continue;
            }
            actualResult.add(fsResource);
        }
        return actualResult;
    }

    protected Set doFindPathMatchingJarResources(Resource rootDirResource, String subPattern) throws IOException {
        try {
            return super.doFindPathMatchingJarResources(rootDirResource, subPattern);
        }
        catch (IOException e) {
            if (rootDirResource.getURL().toExternalForm().indexOf("shared-lib") != -1) {
                return new LinkedHashSet();
            }
            throw e;
        }
    }
}

