/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.support;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.core.cluster.ClusterInfoBeanPostProcessor;
import org.openspaces.core.cluster.ClusterInfoPropertyPlaceholderConfigurer;
import org.openspaces.core.properties.BeanLevelPropertyBeanPostProcessor;
import org.openspaces.core.properties.BeanLevelPropertyPlaceholderConfigurer;
import org.openspaces.pu.container.ProcessingUnitContainerConfig;
import org.openspaces.pu.container.ProcessingUnitContainerContext;
import org.openspaces.pu.container.ProcessingUnitContainerContextBeanPostProcessor;
import org.openspaces.pu.container.support.PUPathMatchingResourcePatternResolver;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ResourceApplicationContext
extends AbstractXmlApplicationContext {
    private static final Log logger = LogFactory.getLog(ResourceApplicationContext.class);
    private Resource[] resources;
    private final CompoundBeanPostProcessor compoundBeanPostProcessor = new CompoundBeanPostProcessor();

    public ResourceApplicationContext(Resource[] resources, ApplicationContext parent) {
        super(parent);
        this.resources = resources;
    }

    public ResourceApplicationContext(Resource[] resources, ApplicationContext parent, ProcessingUnitContainerConfig config) {
        this(resources, parent);
        if (config.getBeanLevelProperties() != null) {
            this.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new BeanLevelPropertyPlaceholderConfigurer(config.getBeanLevelProperties(), config.getClusterInfo()));
            this.addBeanPostProcessor(new BeanLevelPropertyBeanPostProcessor(config.getBeanLevelProperties()));
        }
        if (config.getClusterInfo() != null) {
            this.addBeanPostProcessor(new ClusterInfoBeanPostProcessor(config.getClusterInfo()));
        }
        this.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new ClusterInfoPropertyPlaceholderConfigurer(config.getClusterInfo()));
        this.addBeanPostProcessor(new ProcessingUnitContainerContextBeanPostProcessor(new ProcessingUnitContainerContext(config)));
    }

    protected Resource[] getConfigResources() {
        return this.resources;
    }

    public void addBeanPostProcessor(BeanPostProcessor beanPostProcessor) {
        this.compoundBeanPostProcessor.add(beanPostProcessor);
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        DefaultListableBeanFactory beanFactory = super.createBeanFactory();
        beanFactory.addBeanPostProcessor((BeanPostProcessor)this.compoundBeanPostProcessor);
        return beanFactory;
    }

    protected ResourcePatternResolver getResourcePatternResolver() {
        return new PUPathMatchingResourcePatternResolver();
    }

    private static class CompoundBeanPostProcessor
    implements BeanPostProcessor {
        private final List<BeanPostProcessor> beanPostProcessors = new CopyOnWriteArrayList<BeanPostProcessor>();

        private CompoundBeanPostProcessor() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("postProcessBeforeInitialization(" + beanName + ")"));
            }
            for (BeanPostProcessor beanPostProcessor : this.beanPostProcessors) {
                bean = beanPostProcessor.postProcessBeforeInitialization(bean, beanName);
            }
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("postProcessAfterInitialization(" + beanName + ")"));
            }
            for (BeanPostProcessor beanPostProcessor : this.beanPostProcessors) {
                bean = beanPostProcessor.postProcessAfterInitialization(bean, beanName);
            }
            return bean;
        }

        public void add(BeanPostProcessor beanPostProcessor) {
            this.beanPostProcessors.add(beanPostProcessor);
        }
    }
}

