/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.support;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class WebsterFile
extends File {
    private static final long serialVersionUID = 6166390927496427656L;
    private URL root;
    private URL url;
    private boolean directory = true;
    private long time = -1L;
    private String name;

    public WebsterFile(URL url) {
        super("");
        this.root = url;
        this.url = url;
    }

    WebsterFile(URL root, URL url, String name, long time, boolean directory) throws MalformedURLException {
        super("");
        String fullUrl = url.toExternalForm();
        fullUrl = !fullUrl.endsWith("/") ? fullUrl + "/" + name : fullUrl + name;
        this.root = root;
        this.url = new URL(fullUrl);
        this.time = time;
        this.directory = directory;
        this.name = name;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return super.getName();
        }
        return this.name;
    }

    @Override
    public URL toURL() throws MalformedURLException {
        return this.url;
    }

    @Override
    public String getPath() {
        return this.url.toExternalForm().substring(this.root.toExternalForm().length());
    }

    @Override
    public String getAbsolutePath() {
        return this.url.toExternalForm();
    }

    @Override
    public File getAbsoluteFile() {
        return this;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        return this.directory;
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public File[] listFiles() {
        try {
            String line;
            ArrayList<WebsterFile> filesList = new ArrayList<WebsterFile>();
            HttpURLConnection conn = (HttpURLConnection)this.url.openConnection();
            conn.setDoOutput(false);
            conn.setDoInput(true);
            conn.setAllowUserInteraction(false);
            conn.setUseCaches(false);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("list", "true");
            conn.connect();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = reader.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, "\t");
                String name = tokenizer.nextToken();
                String type = tokenizer.nextToken();
                String size = tokenizer.nextToken();
                long time = Long.parseLong(tokenizer.nextToken());
                WebsterFile add = new WebsterFile(this.root, this.url, name, time, type.equals("d"));
                filesList.add(add);
            }
            reader.close();
            try {
                conn.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return filesList.toArray(new File[filesList.size()]);
        }
        catch (Exception e) {
            return new File[0];
        }
    }

    @Override
    public boolean isFile() {
        return !this.directory;
    }

    @Override
    public long lastModified() {
        return this.time;
    }
}

