/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.service;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openspaces.pu.service.AggregatedServiceDetails;
import org.openspaces.pu.service.ServiceDetails;

public class PlainAggregatedServiceDetails
implements AggregatedServiceDetails,
Externalizable {
    private static final long serialVersionUID = 706793192579879135L;
    private String serviceType;
    private Map<String, Object> attributes = new LinkedHashMap<String, Object>();

    public PlainAggregatedServiceDetails() {
    }

    public PlainAggregatedServiceDetails(String serviceType, ServiceDetails[] details) {
        this.serviceType = serviceType;
        if (details.length > 0) {
            this.attributes.putAll(details[0].getAttributes());
        }
    }

    @Override
    public String getServiceType() {
        return this.serviceType;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.serviceType);
        out.writeInt(this.attributes.size());
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.serviceType = in.readUTF();
        this.attributes = new HashMap<String, Object>();
        int attributesSize = in.readInt();
        for (int i = 0; i < attributesSize; ++i) {
            String key = (String)in.readObject();
            Object value = in.readObject();
            this.attributes.put(key, value);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("type[").append(this.serviceType).append("] ");
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            sb.append(entry.getKey()).append("[").append(entry.getValue()).append("] ");
        }
        return sb.toString();
    }
}

