/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.service;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openspaces.pu.service.AggregatedServiceDetails;
import org.openspaces.pu.service.ServiceDetails;

public class PlainServiceDetails
implements ServiceDetails,
Externalizable {
    private static final long serialVersionUID = -6051967441062799406L;
    protected String id;
    protected String serviceType;
    protected String serviceSubType;
    protected String description;
    protected String longDescription;
    protected Map<String, Object> attributes = new LinkedHashMap<String, Object>();

    public PlainServiceDetails() {
    }

    public PlainServiceDetails(String id, String serviceType, String serviceSubType, String description, String longDescription) {
        this.id = id;
        this.serviceType = serviceType;
        this.serviceSubType = serviceSubType;
        this.description = description;
        if (this.description == null) {
            this.description = "";
        }
        this.longDescription = longDescription;
        if (this.longDescription == null) {
            this.longDescription = "";
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getServiceType() {
        return this.serviceType;
    }

    @Override
    public String getServiceSubType() {
        return this.serviceSubType;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getLongDescription() {
        return this.longDescription;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public AggregatedServiceDetails aggregateByServiceType(ServiceDetails[] servicesDetails) {
        return null;
    }

    public AggregatedServiceDetails aggregateByServiceSubType(ServiceDetails[] servicesDetails) {
        return null;
    }

    public AggregatedServiceDetails aggregateById(ServiceDetails[] servicesDetails) {
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.id);
        out.writeUTF(this.serviceType);
        out.writeUTF(this.serviceSubType);
        out.writeUTF(this.description);
        out.writeUTF(this.longDescription);
        if (this.attributes == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.attributes.size());
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                out.writeObject(entry.getKey());
                out.writeObject(entry.getValue());
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readUTF();
        this.serviceType = in.readUTF();
        this.serviceSubType = in.readUTF();
        this.description = in.readUTF();
        this.longDescription = in.readUTF();
        this.attributes = new LinkedHashMap<String, Object>();
        int attributesSize = in.readInt();
        for (int i = 0; i < attributesSize; ++i) {
            String key = (String)in.readObject();
            Object value = in.readObject();
            this.attributes.put(key, value);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id[").append(this.id).append("] ");
        sb.append("type[").append(this.serviceType).append("/").append(this.serviceSubType).append("] ");
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            sb.append(entry.getKey()).append("[").append(entry.getValue()).append("] ");
        }
        return sb.toString();
    }
}

