/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.service;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openspaces.pu.service.ServiceDetails;
import org.openspaces.pu.service.ServiceMonitors;

public class PlainServiceMonitors
implements ServiceMonitors,
Externalizable {
    private static final long serialVersionUID = -2530051320077906919L;
    protected String id;
    protected ServiceDetails details;
    protected Map<String, Object> monitors;

    public PlainServiceMonitors() {
    }

    public PlainServiceMonitors(String id) {
        this.id = id;
        this.monitors = new LinkedHashMap<String, Object>();
    }

    public PlainServiceMonitors(String id, Map<String, Object> monitors) {
        this.id = id;
        this.monitors = new LinkedHashMap<String, Object>(monitors);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Map<String, Object> getMonitors() {
        return this.monitors;
    }

    @Override
    public ServiceDetails getDetails() {
        return this.details;
    }

    public void setDetails(ServiceDetails details) {
        this.details = details;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.id);
        if (this.monitors == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.monitors.size());
            for (Map.Entry<String, Object> entry : this.monitors.entrySet()) {
                out.writeObject(entry.getKey());
                out.writeObject(entry.getValue());
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readUTF();
        int attributesSize = in.readInt();
        if (attributesSize == 0) {
            this.monitors = Collections.EMPTY_MAP;
        } else {
            this.monitors = new LinkedHashMap<String, Object>();
            for (int i = 0; i < attributesSize; ++i) {
                String key = (String)in.readObject();
                Object value = in.readObject();
                this.monitors.put(key, value);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id[").append(this.id).append("] ");
        for (Map.Entry<String, Object> entry : this.monitors.entrySet()) {
            sb.append(entry.getKey()).append("[").append(entry.getValue()).append("] ");
        }
        return sb.toString();
    }
}

