/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.remoting;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openspaces.core.GigaSpace;
import org.openspaces.remoting.SpaceRemoteExecutionException;
import org.openspaces.remoting.SpaceRemotingEntry;
import org.openspaces.remoting.SpaceRemotingResult;

public class EventDrivenRemoteFuture<T>
implements Future<T> {
    private final GigaSpace gigaSpace;
    private SpaceRemotingEntry remotingEntry;
    private volatile Boolean cancelled;
    private volatile SpaceRemotingResult remoteResult;
    private SpaceRemotingEntry template;

    public EventDrivenRemoteFuture(GigaSpace gigaSpace, SpaceRemotingEntry remotingEntry) {
        this.gigaSpace = gigaSpace;
        this.remotingEntry = remotingEntry;
        try {
            this.template = ((SpaceRemotingEntry)remotingEntry.clone()).buildResultTemplate();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.cancelled != null) {
            return this.cancelled;
        }
        SpaceRemotingEntry retVal = this.gigaSpace.take(this.remotingEntry, 0L);
        this.cancelled = retVal != null;
        return this.cancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled != null && this.cancelled != false;
    }

    @Override
    public boolean isDone() {
        if (this.cancelled != null) {
            return true;
        }
        if (this.remoteResult != null) {
            return true;
        }
        this.remoteResult = this.gigaSpace.take(this.template, 0L);
        return this.remoteResult != null;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        if (this.cancelled != null) {
            throw new CancellationException();
        }
        T retVal = this.handleResult();
        if (retVal != null) {
            return retVal;
        }
        this.remoteResult = this.gigaSpace.take(this.template, Integer.MAX_VALUE);
        return this.handleResult();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.cancelled != null) {
            throw new CancellationException();
        }
        T retVal = this.handleResult();
        if (retVal != null) {
            return retVal;
        }
        this.remoteResult = this.gigaSpace.take(this.template, unit.toMillis(timeout));
        if (this.remoteResult == null) {
            throw new TimeoutException("Timeout waiting for remote invocation [" + this.remotingEntry + "] for [" + unit.toMillis(timeout) + "] milliseconds");
        }
        return this.handleResult();
    }

    private T handleResult() throws ExecutionException {
        if (this.remoteResult == null) {
            return null;
        }
        if (this.remoteResult.getException() != null) {
            throw new SpaceRemoteExecutionException(this.remotingEntry, this.remoteResult);
        }
        return this.remoteResult.getResult();
    }
}

