/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.remoting;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Future;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.openspaces.core.GigaSpace;
import org.openspaces.remoting.EventDrivenRemoteFuture;
import org.openspaces.remoting.EventDrivenRemotingMethod;
import org.openspaces.remoting.HashedSpaceRemotingEntry;
import org.openspaces.remoting.MetaArgumentsHandler;
import org.openspaces.remoting.RemoteInvocationAspect;
import org.openspaces.remoting.RemoteRoutingHandler;
import org.openspaces.remoting.RemoteTimeoutException;
import org.openspaces.remoting.RemotingInvoker;
import org.openspaces.remoting.RemotingProxyUtils;
import org.openspaces.remoting.RemotingUtils;
import org.openspaces.remoting.SpaceRemotingEntry;
import org.openspaces.remoting.SpaceRemotingEntryFactory;
import org.openspaces.remoting.SpaceRemotingEntryMetadataFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.remoting.support.RemoteAccessor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class EventDrivenSpaceRemotingProxyFactoryBean
extends RemoteAccessor
implements FactoryBean,
InitializingBean,
MethodInterceptor,
RemotingInvoker,
ApplicationContextAware {
    public static final String DEFAULT_ASYNC_METHOD_PREFIX = "async";
    private GigaSpace gigaSpace;
    private long timeout = 60000L;
    private final SpaceRemotingEntryFactory remotingEntryFactory = new SpaceRemotingEntryMetadataFactory();
    private RemoteRoutingHandler remoteRoutingHandler;
    private MetaArgumentsHandler metaArgumentsHandler;
    private boolean globalOneWay = false;
    private boolean voidOneWay = false;
    private boolean fifo = false;
    private String asyncMethodPrefix = "async";
    private RemoteInvocationAspect remoteInvocationAspect;
    private Object serviceProxy;
    private Map<Method, RemotingUtils.MethodHash> methodHashLookup;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setGigaSpace(GigaSpace gigaSpace) {
        this.gigaSpace = gigaSpace;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setRemoteRoutingHandler(RemoteRoutingHandler remoteRoutingHandler) {
        this.remoteRoutingHandler = remoteRoutingHandler;
    }

    public void setMetaArgumentsHandler(MetaArgumentsHandler metaArgumentsHandler) {
        this.metaArgumentsHandler = metaArgumentsHandler;
    }

    public void setGlobalOneWay(boolean globalOneWay) {
        this.globalOneWay = globalOneWay;
    }

    public void setVoidOneWay(boolean voidOneWay) {
        this.voidOneWay = voidOneWay;
    }

    public void setFifo(boolean fifo) {
        this.fifo = fifo;
    }

    public void setAsyncMethodPrefix(String asyncMethodPrefix) {
        this.asyncMethodPrefix = asyncMethodPrefix;
    }

    public void setRemoteInvocationAspect(RemoteInvocationAspect remoteInvocationAspect) {
        this.remoteInvocationAspect = remoteInvocationAspect;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.getServiceInterface(), (String)"serviceInterface property is required");
        Assert.notNull((Object)this.gigaSpace, (String)"gigaSpace property is required");
        this.serviceProxy = ProxyFactory.getProxy((Class)this.getServiceInterface(), (Interceptor)this);
        this.methodHashLookup = RemotingUtils.buildMethodToHashLookupForInterface(this.getServiceInterface(), this.asyncMethodPrefix);
    }

    public Object getObject() {
        return this.serviceProxy;
    }

    public Class<?> getObjectType() {
        return this.getServiceInterface();
    }

    public boolean isSingleton() {
        return true;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Annotation[] methodAnnotations;
        RemoteInvocationAspect localRemoteInvocationAspect = null;
        for (Annotation methodAnnotation : methodAnnotations = methodInvocation.getMethod().getAnnotations()) {
            if (!(methodAnnotation instanceof EventDrivenRemotingMethod)) continue;
            EventDrivenRemotingMethod remotingMethodAnnotation = (EventDrivenRemotingMethod)methodAnnotation;
            localRemoteInvocationAspect = (RemoteInvocationAspect)RemotingUtils.createByClassOrFindByName(this.applicationContext, remotingMethodAnnotation.remoteInvocationAspect(), remotingMethodAnnotation.remoteInvocationAspectType());
        }
        if (localRemoteInvocationAspect == null) {
            localRemoteInvocationAspect = this.remoteInvocationAspect;
        }
        if (localRemoteInvocationAspect != null) {
            return localRemoteInvocationAspect.invoke(methodInvocation, this);
        }
        return this.invokeRemote(methodInvocation);
    }

    @Override
    public Object invokeRemote(MethodInvocation methodInvocation) throws Throwable {
        String lookupName = this.getServiceInterface().getName();
        String methodName = methodInvocation.getMethod().getName();
        boolean localFifo = false;
        boolean localVoidOneWay = false;
        boolean localGlobalOneWay = false;
        RemoteRoutingHandler localRoutingHandler = null;
        MetaArgumentsHandler localMetaArgumentsHandler = null;
        long localTimeout = -1L;
        Annotation[] methodAnnotations = methodInvocation.getMethod().getAnnotations();
        boolean hasMethodLevelRemotingAnnotation = false;
        for (Annotation methodAnnotation : methodAnnotations) {
            if (!(methodAnnotation instanceof EventDrivenRemotingMethod)) continue;
            hasMethodLevelRemotingAnnotation = true;
            EventDrivenRemotingMethod remotingMethodAnnotation = (EventDrivenRemotingMethod)methodAnnotation;
            localFifo = remotingMethodAnnotation.fifo();
            localGlobalOneWay = remotingMethodAnnotation.globalOneWay();
            localVoidOneWay = remotingMethodAnnotation.voidOneWay();
            localMetaArgumentsHandler = (MetaArgumentsHandler)RemotingUtils.createByClassOrFindByName(this.applicationContext, remotingMethodAnnotation.metaArgumentsHandler(), remotingMethodAnnotation.metaArgumentsHandlerType());
            localTimeout = remotingMethodAnnotation.timeout();
            localRoutingHandler = (RemoteRoutingHandler)RemotingUtils.createByClassOrFindByName(this.applicationContext, remotingMethodAnnotation.remoteRoutingHandler(), remotingMethodAnnotation.remoteRoutingHandlerType());
        }
        if (!hasMethodLevelRemotingAnnotation) {
            localFifo = this.fifo;
            localVoidOneWay = this.voidOneWay;
            localGlobalOneWay = this.globalOneWay;
            localRoutingHandler = this.remoteRoutingHandler;
            localMetaArgumentsHandler = this.metaArgumentsHandler;
            localTimeout = this.timeout;
        }
        boolean asyncExecution = false;
        if (Future.class.isAssignableFrom(methodInvocation.getMethod().getReturnType())) {
            asyncExecution = true;
            if (methodName.startsWith(this.asyncMethodPrefix)) {
                methodName = StringUtils.uncapitalize((String)methodName.substring(this.asyncMethodPrefix.length()));
            }
        }
        HashedSpaceRemotingEntry remotingEntry = this.remotingEntryFactory.createHashEntry().buildInvocation(lookupName, methodName, this.methodHashLookup.get(methodInvocation.getMethod()), methodInvocation.getArguments());
        remotingEntry.setRouting(RemotingProxyUtils.computeRouting(remotingEntry, localRoutingHandler, methodInvocation));
        if (localMetaArgumentsHandler != null) {
            remotingEntry.setMetaArguments(localMetaArgumentsHandler.obtainMetaArguments(remotingEntry));
        }
        if (localGlobalOneWay) {
            remotingEntry.setOneWay(Boolean.TRUE);
        } else if (localVoidOneWay && methodInvocation.getMethod().getReturnType() == Void.TYPE) {
            remotingEntry.setOneWay(Boolean.TRUE);
        }
        remotingEntry.setFifo(localFifo);
        this.gigaSpace.write(remotingEntry);
        if (remotingEntry.getOneWay() != null && remotingEntry.getOneWay().booleanValue()) {
            return null;
        }
        if (asyncExecution) {
            return new EventDrivenRemoteFuture(this.gigaSpace, remotingEntry);
        }
        SpaceRemotingEntry invokeResult = this.gigaSpace.take(remotingEntry.buildResultTemplate(), localTimeout);
        if (invokeResult == null) {
            throw new RemoteTimeoutException("Timeout waiting for result for [" + lookupName + "] and method [" + methodName + "]", localTimeout);
        }
        if (invokeResult.getException() != null) {
            throw invokeResult.getException();
        }
        return invokeResult.getResult();
    }
}

