/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.remoting;

import com.gigaspaces.async.AsyncResult;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.cluster.ClusterInfoAware;
import org.openspaces.core.executor.DistributedTask;
import org.openspaces.core.executor.TaskRoutingProvider;
import org.openspaces.remoting.RemotingUtils;
import org.openspaces.remoting.SpaceRemotingInvocation;
import org.openspaces.remoting.SpaceRemotingServiceExporter;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ExecutorRemotingTask<T extends Serializable>
implements DistributedTask<InternalExecutorResult<T>, List<AsyncResult<InternalExecutorResult<T>>>>,
ApplicationContextAware,
ClusterInfoAware,
TaskRoutingProvider,
SpaceRemotingInvocation,
Externalizable {
    static final long serialVersionUID = -3901451909736348231L;
    private static final transient Log logger = LogFactory.getLog(ExecutorRemotingTask.class);
    private String lookupName;
    private String methodName;
    private RemotingUtils.MethodHash methodHash;
    private Object[] arguments;
    private Object[] metaArguments;
    private Object routing;
    private transient ApplicationContext applicationContext;
    private transient Integer instanceId;
    private transient SpaceRemotingServiceExporter serviceExporter;

    public ExecutorRemotingTask() {
    }

    public ExecutorRemotingTask(String lookupName, String methodName, RemotingUtils.MethodHash methodHash, Object[] arguments) {
        this.lookupName = lookupName;
        this.methodName = methodName;
        this.methodHash = methodHash;
        this.arguments = arguments;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void setClusterInfo(ClusterInfo clusterInfo) {
        this.instanceId = clusterInfo.getInstanceId();
    }

    public void setServiceExporter(SpaceRemotingServiceExporter serviceExporter) {
        this.serviceExporter = serviceExporter;
    }

    @Override
    public InternalExecutorResult<T> execute() throws Exception {
        try {
            Object result = this.serviceExporter.invokeExecutor(this);
            return new InternalExecutorResult<Serializable>((Serializable)result, this.instanceId);
        }
        catch (Throwable e) {
            throw new InternalExecutorException(e, this.instanceId, this.lookupName, this.methodName);
        }
    }

    public static SpaceRemotingServiceExporter getServiceExporter(ApplicationContext applicationContext) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Looking for default serviceExporter - applicationContext.getBean(\"serviceExporter\")");
            }
            return (SpaceRemotingServiceExporter)applicationContext.getBean("serviceExporter");
        }
        catch (NoSuchBeanDefinitionException e) {
            String[] names = applicationContext.getBeanNamesForType(SpaceRemotingServiceExporter.class, false, true);
            if (names == null || names.length == 0) {
                throw new IllegalStateException("Failed to find remoting service exporter defined within the application context");
            }
            String name = names[0];
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Looking for first serviceExporter - applicationContext.getBean(" + name + ")"));
            }
            return (SpaceRemotingServiceExporter)applicationContext.getBean(name);
        }
    }

    public List<AsyncResult<InternalExecutorResult<T>>> reduce(List<AsyncResult<InternalExecutorResult<T>>> results) throws Exception {
        return results;
    }

    @Override
    public Object getRouting() {
        return this.routing;
    }

    void setRouting(Object routing) {
        this.routing = routing;
    }

    @Override
    public String getLookupName() {
        return this.lookupName;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    public RemotingUtils.MethodHash getMethodHash() {
        return this.methodHash;
    }

    @Override
    public Object[] getArguments() {
        return this.arguments;
    }

    @Override
    public Object[] getMetaArguments() {
        return this.metaArguments;
    }

    void setMetaArguments(Object[] metaArguments) {
        this.metaArguments = metaArguments;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.lookupName);
        out.writeUTF(this.methodName);
        if (this.arguments == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.arguments.length);
            for (Object arg : this.arguments) {
                out.writeObject(arg);
            }
        }
        if (this.metaArguments == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.metaArguments.length);
            for (Object arg : this.metaArguments) {
                out.writeObject(arg);
            }
        }
        this.methodHash.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        this.lookupName = in.readUTF();
        this.methodName = in.readUTF();
        int size = in.readInt();
        if (size > 0) {
            this.arguments = new Object[size];
            for (i = 0; i < size; ++i) {
                this.arguments[i] = in.readObject();
            }
        }
        if ((size = in.readInt()) > 0) {
            this.metaArguments = new Object[size];
            for (i = 0; i < size; ++i) {
                this.metaArguments[i] = in.readObject();
            }
        }
        this.methodHash = new RemotingUtils.MethodHash();
        this.methodHash.readExternal(in);
    }

    public static class InternalExecutorException
    extends Exception
    implements Externalizable {
        private static final long serialVersionUID = 7604645076693946565L;
        private Throwable exception;
        private Integer instanceId;
        private transient String lookupName;
        private transient String methodName;

        public InternalExecutorException() {
        }

        public InternalExecutorException(Throwable exception, Integer instanceId, String lookupName, String methodName) {
            this.exception = exception;
            this.instanceId = instanceId;
            this.lookupName = lookupName;
            this.methodName = methodName;
        }

        public Throwable getException() {
            return this.exception;
        }

        public int getInstanceId() {
            return this.instanceId;
        }

        @Override
        public Throwable fillInStackTrace() {
            return null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            try {
                out.writeObject(this.exception);
            }
            catch (NotSerializableException e) {
                logger.warn((Object)("Non serializable exception raised by [" + this.lookupName + "] and method [" + this.methodName + "], root exception: [" + JSpaceUtilities.getStackTrace((Throwable)this.exception) + "]"), (Throwable)e);
                throw e;
            }
            if (this.instanceId == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeInt(this.instanceId);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.exception = (Throwable)in.readObject();
            if (in.readBoolean()) {
                this.instanceId = in.readInt();
            }
        }
    }

    public static class InternalExecutorResult<T extends Serializable>
    implements Externalizable {
        private static final long serialVersionUID = -5336727166040169828L;
        private T result;
        private Integer instanceId;

        public InternalExecutorResult() {
        }

        public InternalExecutorResult(T result, Integer instanceId) {
            this.result = result;
            this.instanceId = instanceId;
        }

        public T getResult() {
            return this.result;
        }

        public int getInstanceId() {
            return this.instanceId;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            if (this.result == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeObject(this.result);
            }
            if (this.instanceId == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeInt(this.instanceId);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            if (in.readBoolean()) {
                this.result = (Serializable)in.readObject();
            }
            if (in.readBoolean()) {
                this.instanceId = in.readInt();
            }
        }
    }
}

