/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.remoting;

import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.async.internal.DefaultAsyncResult;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.openspaces.core.GigaSpace;
import org.openspaces.remoting.BroadcastIndicator;
import org.openspaces.remoting.ExecutorRemotingMethod;
import org.openspaces.remoting.ExecutorRemotingTask;
import org.openspaces.remoting.MetaArgumentsHandler;
import org.openspaces.remoting.RemoteInvocationAspect;
import org.openspaces.remoting.RemoteResultReducer;
import org.openspaces.remoting.RemoteRoutingHandler;
import org.openspaces.remoting.RemoteTimeoutException;
import org.openspaces.remoting.RemotingInvoker;
import org.openspaces.remoting.RemotingProxyUtils;
import org.openspaces.remoting.RemotingUtils;
import org.openspaces.remoting.SpaceRemotingResult;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.remoting.support.RemoteAccessor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ExecutorSpaceRemotingProxyFactoryBean
extends RemoteAccessor
implements FactoryBean,
InitializingBean,
MethodInterceptor,
RemotingInvoker,
ApplicationContextAware {
    public static final String DEFAULT_ASYNC_METHOD_PREFIX = "async";
    private GigaSpace gigaSpace;
    private long timeout = 60000L;
    private RemoteRoutingHandler remoteRoutingHandler;
    private MetaArgumentsHandler metaArgumentsHandler;
    private final String asyncMethodPrefix = "async";
    private boolean broadcast = false;
    private boolean returnFirstResult = true;
    private RemoteResultReducer remoteResultReducer;
    private RemoteInvocationAspect remoteInvocationAspect;
    private Object serviceProxy;
    private Map<Method, RemotingUtils.MethodHash> methodHashLookup;
    private ApplicationContext applicationContext;

    public void setGigaSpace(GigaSpace gigaSpace) {
        this.gigaSpace = gigaSpace;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setRemoteRoutingHandler(RemoteRoutingHandler remoteRoutingHandler) {
        this.remoteRoutingHandler = remoteRoutingHandler;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public void setRemoteResultReducer(RemoteResultReducer remoteResultReducer) {
        this.remoteResultReducer = remoteResultReducer;
    }

    public void setMetaArgumentsHandler(MetaArgumentsHandler metaArgumentsHandler) {
        this.metaArgumentsHandler = metaArgumentsHandler;
    }

    public void setReturnFirstResult(boolean returnFirstResult) {
        this.returnFirstResult = returnFirstResult;
    }

    public void setRemoteInvocationAspect(RemoteInvocationAspect remoteInvocationAspect) {
        this.remoteInvocationAspect = remoteInvocationAspect;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.getServiceInterface(), (String)"serviceInterface property is required");
        Assert.notNull((Object)this.gigaSpace, (String)"gigaSpace property is required");
        this.serviceProxy = ProxyFactory.getProxy((Class)this.getServiceInterface(), (Interceptor)this);
        this.methodHashLookup = RemotingUtils.buildMethodToHashLookupForInterface(this.getServiceInterface(), DEFAULT_ASYNC_METHOD_PREFIX);
    }

    public Object getObject() {
        return this.serviceProxy;
    }

    public Class<?> getObjectType() {
        return this.getServiceInterface();
    }

    public boolean isSingleton() {
        return true;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Annotation[] methodAnnotations;
        RemoteInvocationAspect localRemoteInvocationAspect = null;
        for (Annotation methodAnnotation : methodAnnotations = methodInvocation.getMethod().getAnnotations()) {
            if (!(methodAnnotation instanceof ExecutorRemotingMethod)) continue;
            ExecutorRemotingMethod remotingMethodAnnotation = (ExecutorRemotingMethod)methodAnnotation;
            localRemoteInvocationAspect = (RemoteInvocationAspect)RemotingUtils.createByClassOrFindByName(this.applicationContext, remotingMethodAnnotation.remoteInvocationAspect(), remotingMethodAnnotation.remoteInvocationAspectType());
        }
        if (localRemoteInvocationAspect == null) {
            localRemoteInvocationAspect = this.remoteInvocationAspect;
        }
        if (localRemoteInvocationAspect != null) {
            return localRemoteInvocationAspect.invoke(methodInvocation, this);
        }
        return this.invokeRemote(methodInvocation);
    }

    @Override
    public Object invokeRemote(MethodInvocation methodInvocation) throws Throwable {
        Object future;
        String lookupName = this.getServiceInterface().getName();
        String methodName = methodInvocation.getMethod().getName();
        boolean asyncExecution = false;
        if (Future.class.isAssignableFrom(methodInvocation.getMethod().getReturnType())) {
            asyncExecution = true;
            if (methodName.startsWith(DEFAULT_ASYNC_METHOD_PREFIX)) {
                methodName = StringUtils.uncapitalize((String)methodName.substring(DEFAULT_ASYNC_METHOD_PREFIX.length()));
            }
        }
        ExecutorRemotingTask task = new ExecutorRemotingTask(lookupName, methodName, this.methodHashLookup.get(methodInvocation.getMethod()), methodInvocation.getArguments());
        BroadcastIndicator broadcastIndicator = null;
        RemoteResultReducer localRemoteResultReducer = null;
        RemoteRoutingHandler localRoutingHandler = null;
        MetaArgumentsHandler localMetaArgumentsHandler = null;
        Boolean localShouldBroadcast = null;
        if (methodInvocation.getArguments() != null && methodInvocation.getArguments().length > 0 && methodInvocation.getArguments()[0] instanceof BroadcastIndicator) {
            broadcastIndicator = (BroadcastIndicator)methodInvocation.getArguments()[0];
            if (broadcastIndicator.shouldBroadcast() != null) {
                localShouldBroadcast = broadcastIndicator.shouldBroadcast();
                localRemoteResultReducer = broadcastIndicator.getReducer();
            }
        } else {
            Annotation[] methodAnnotations;
            for (Annotation methodAnnotation : methodAnnotations = methodInvocation.getMethod().getAnnotations()) {
                if (!(methodAnnotation instanceof ExecutorRemotingMethod)) continue;
                ExecutorRemotingMethod remotingMethodAnnotation = (ExecutorRemotingMethod)methodAnnotation;
                if (remotingMethodAnnotation.broadcast()) {
                    localShouldBroadcast = true;
                    localRemoteResultReducer = (RemoteResultReducer)RemotingUtils.createByClassOrFindByName(this.applicationContext, remotingMethodAnnotation.remoteResultReducer(), remotingMethodAnnotation.remoteResultReducerType());
                } else {
                    localShouldBroadcast = false;
                    RemoteRoutingHandler methodRoutingHandler = (RemoteRoutingHandler)RemotingUtils.createByClassOrFindByName(this.applicationContext, remotingMethodAnnotation.remoteRoutingHandler(), remotingMethodAnnotation.remoteRoutingHandlerType());
                    if (methodRoutingHandler != null) {
                        localRoutingHandler = methodRoutingHandler;
                    }
                }
                localMetaArgumentsHandler = (MetaArgumentsHandler)RemotingUtils.createByClassOrFindByName(this.applicationContext, remotingMethodAnnotation.metaArgumentsHandler(), remotingMethodAnnotation.metaArgumentsHandlerType());
            }
        }
        if (localRemoteResultReducer == null) {
            localRemoteResultReducer = this.remoteResultReducer;
        }
        if (localRoutingHandler == null) {
            localRoutingHandler = this.remoteRoutingHandler;
        }
        if (localMetaArgumentsHandler == null) {
            localMetaArgumentsHandler = this.metaArgumentsHandler;
        }
        if (localShouldBroadcast == null) {
            localShouldBroadcast = this.broadcast;
        }
        if (!localShouldBroadcast.booleanValue()) {
            task.setRouting(RemotingProxyUtils.computeRouting(task, localRoutingHandler, methodInvocation));
        }
        if (localMetaArgumentsHandler != null) {
            task.setMetaArguments(localMetaArgumentsHandler.obtainMetaArguments(task));
        }
        if (localShouldBroadcast.booleanValue()) {
            future = new DistributedExecutorAsyncFuture(this.gigaSpace.execute(task), localRemoteResultReducer, task);
            if (asyncExecution) {
                return future;
            }
            try {
                return ((DistributedExecutorAsyncFuture)future).get(this.timeout, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
            catch (TimeoutException e) {
                throw new RemoteTimeoutException("Timeout waiting for result for [" + lookupName + "] and method [" + methodName + "]", this.timeout);
            }
        }
        future = new ExecutorAsyncFuture(this.gigaSpace.execute(task, task.getRouting()), task);
        if (asyncExecution) {
            return future;
        }
        try {
            return ((ExecutorAsyncFuture)future).get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
        catch (TimeoutException e) {
            throw new RemoteTimeoutException("Timeout waiting for result for [" + lookupName + "] and method [" + methodName + "]", this.timeout);
        }
    }

    private static class ExecutorSpaceRemotingResult<T extends Serializable>
    implements SpaceRemotingResult<T> {
        private final AsyncResult<ExecutorRemotingTask.InternalExecutorResult<T>> asyncResult;
        private final Integer routing;

        public ExecutorSpaceRemotingResult(AsyncResult<ExecutorRemotingTask.InternalExecutorResult<T>> asyncResult, Integer routing) {
            this.asyncResult = asyncResult;
            this.routing = routing;
        }

        @Override
        public Integer getRouting() {
            return this.routing;
        }

        @Override
        public T getResult() {
            if (this.asyncResult.getException() == null) {
                return ((ExecutorRemotingTask.InternalExecutorResult)this.asyncResult.getResult()).getResult();
            }
            return null;
        }

        @Override
        public Throwable getException() {
            if (this.asyncResult.getException() != null) {
                if (this.asyncResult.getException() instanceof ExecutorRemotingTask.InternalExecutorException) {
                    return ((ExecutorRemotingTask.InternalExecutorException)this.asyncResult.getException()).getException();
                }
                return this.asyncResult.getException();
            }
            return null;
        }

        @Override
        public Integer getInstanceId() {
            if (this.asyncResult.getException() != null) {
                if (this.asyncResult.getException() instanceof ExecutorRemotingTask.InternalExecutorException) {
                    return ((ExecutorRemotingTask.InternalExecutorException)this.asyncResult.getException()).getInstanceId();
                }
                return null;
            }
            return ((ExecutorRemotingTask.InternalExecutorResult)this.asyncResult.getResult()).getInstanceId();
        }
    }

    private static class ExecutorAsyncFutureListener
    implements AsyncFutureListener {
        private final AsyncFutureListener listener;

        private ExecutorAsyncFutureListener(AsyncFutureListener listener) {
            this.listener = listener;
        }

        public void onResult(AsyncResult result) {
            if (result.getException() != null) {
                Exception e = result.getException();
                if (e instanceof ExecutorRemotingTask.InternalExecutorException) {
                    e = (Exception)((ExecutorRemotingTask.InternalExecutorException)e).getException();
                }
                this.listener.onResult((AsyncResult)new DefaultAsyncResult(null, e));
            } else {
                Object res = ((ExecutorRemotingTask.InternalExecutorResult)result.getResult()).getResult();
                this.listener.onResult((AsyncResult)new DefaultAsyncResult(res, null));
            }
        }
    }

    private static class ExecutorAsyncFuture
    implements AsyncFuture {
        private final AsyncFuture<ExecutorRemotingTask.InternalExecutorResult> future;
        private final ExecutorRemotingTask task;

        private ExecutorAsyncFuture(AsyncFuture<ExecutorRemotingTask.InternalExecutorResult> future, ExecutorRemotingTask task) {
            this.future = future;
            this.task = task;
        }

        public void setListener(AsyncFutureListener listener) {
            this.future.setListener((AsyncFutureListener)new ExecutorAsyncFutureListener(listener));
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        public boolean isDone() {
            return this.future.isDone();
        }

        public Object get() throws InterruptedException, ExecutionException {
            try {
                ExecutorRemotingTask.InternalExecutorResult result = (ExecutorRemotingTask.InternalExecutorResult)this.future.get();
                return result.getResult();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof ExecutorRemotingTask.InternalExecutorException) {
                    throw new ExecutionException("Failed to invoke service [" + this.task.getLookupName() + "] with method [" + this.task.getMethodName() + "]", ((ExecutorRemotingTask.InternalExecutorException)e.getCause()).getException());
                }
                throw e;
            }
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                ExecutorRemotingTask.InternalExecutorResult result = (ExecutorRemotingTask.InternalExecutorResult)this.future.get(timeout, unit);
                return result.getResult();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof ExecutorRemotingTask.InternalExecutorException) {
                    throw new ExecutionException("Failed to invoke service [" + this.task.getLookupName() + "] with method [" + this.task.getMethodName() + "]", ((ExecutorRemotingTask.InternalExecutorException)e.getCause()).getException());
                }
                throw e;
            }
        }
    }

    private class DistributedExecutorAsyncFuture
    implements AsyncFuture {
        private final AsyncFuture<List<AsyncResult<ExecutorRemotingTask.InternalExecutorResult>>> future;
        private final RemoteResultReducer remoteResultReducer;
        private final ExecutorRemotingTask task;

        public DistributedExecutorAsyncFuture(AsyncFuture<List<AsyncResult<ExecutorRemotingTask.InternalExecutorResult>>> future, RemoteResultReducer remoteResultReducer, ExecutorRemotingTask task) {
            this.future = future;
            this.remoteResultReducer = remoteResultReducer;
            this.task = task;
        }

        public void setListener(AsyncFutureListener listener) {
            this.future.setListener((AsyncFutureListener)new ExecutorAsyncFutureListener(listener));
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        public boolean isDone() {
            return this.future.isDone();
        }

        public Object get() throws InterruptedException, ExecutionException {
            try {
                return this.get(-1L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                throw new ExecutionException("Timeout exception", e);
            }
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                Object retVal;
                List results = timeout == -1L ? (List)this.future.get() : (List)this.future.get(timeout, unit);
                if (this.remoteResultReducer != null) {
                    SpaceRemotingResult[] ret = new SpaceRemotingResult[results.size()];
                    int i = 0;
                    for (AsyncResult result : results) {
                        ret[i++] = new ExecutorSpaceRemotingResult(result, null);
                    }
                    retVal = this.remoteResultReducer.reduce(ret, this.task);
                } else {
                    if (ExecutorSpaceRemotingProxyFactoryBean.this.returnFirstResult) {
                        AsyncResult result = (AsyncResult)results.iterator().next();
                        if (result.getException() != null) {
                            throw result.getException();
                        }
                        return result.getResult();
                    }
                    Object[] retVals = new Object[results.size()];
                    int i = 0;
                    for (AsyncResult result : results) {
                        if (result.getException() != null) {
                            throw result.getException();
                        }
                        retVals[i++] = ((ExecutorRemotingTask.InternalExecutorResult)result.getResult()).getResult();
                    }
                    retVal = retVals;
                }
                return retVal;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof ExecutorRemotingTask.InternalExecutorException) {
                    throw new ExecutionException("Failed to invoke service [" + this.task.getLookupName() + "] with method [" + this.task.getMethodName() + "]", ((ExecutorRemotingTask.InternalExecutorException)e.getCause()).getException());
                }
                throw e;
            }
            catch (Throwable e) {
                Throwable actualException = e;
                if (e instanceof ExecutorRemotingTask.InternalExecutorException) {
                    actualException = ((ExecutorRemotingTask.InternalExecutorException)e).getException();
                }
                throw new ExecutionException("Failed to invoke service [" + this.task.getLookupName() + "] with method [" + this.task.getMethodName() + "]", actualException);
            }
        }
    }
}

