/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.remoting;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.util.AnnotationUtils;
import org.openspaces.remoting.EventDrivenProxy;
import org.openspaces.remoting.EventDrivenSpaceRemotingProxyFactoryBean;
import org.openspaces.remoting.ExecutorProxy;
import org.openspaces.remoting.ExecutorSpaceRemotingProxyFactoryBean;
import org.openspaces.remoting.MetaArgumentsHandler;
import org.openspaces.remoting.RemoteInvocationAspect;
import org.openspaces.remoting.RemoteResultReducer;
import org.openspaces.remoting.RemoteRoutingHandler;
import org.openspaces.remoting.RemotingService;
import org.openspaces.remoting.RemotingUtils;
import org.openspaces.remoting.SpaceRemotingServiceExporter;
import org.openspaces.remoting.scripting.EventDrivenScriptingExecutor;
import org.openspaces.remoting.scripting.ExecutorScriptingExecutor;
import org.openspaces.remoting.scripting.LazyLoadingRemoteInvocationAspect;
import org.openspaces.remoting.scripting.ScriptingExecutor;
import org.openspaces.remoting.scripting.ScriptingMetaArgumentsHandler;
import org.openspaces.remoting.scripting.ScriptingRemoteRoutingHandler;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class RemotingAnnotationBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements ApplicationContextAware,
Ordered {
    private static final Log logger = LogFactory.getLog(RemotingAnnotationBeanPostProcessor.class);
    private ApplicationContext applicationContext;
    private Map<String, GigaSpace> gsByName;
    private GigaSpace uniqueGs;
    private int order = Integer.MAX_VALUE;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean == null) {
            return bean;
        }
        Class beanClass = AopUtils.getTargetClass((Object)bean);
        if (beanClass == null) {
            return bean;
        }
        RemotingService remotingService = AnnotationUtils.findAnnotation(beanClass, RemotingService.class);
        if (remotingService != null) {
            SpaceRemotingServiceExporter exporter;
            if (StringUtils.hasLength((String)remotingService.exporter())) {
                exporter = (SpaceRemotingServiceExporter)this.applicationContext.getBean(remotingService.exporter());
                if (exporter == null) {
                    throw new IllegalArgumentException("Failed to find exporter under name [" + remotingService.exporter() + "] for bean [" + beanName + "]");
                }
            } else {
                Map exporters = this.applicationContext.getBeansOfType(SpaceRemotingServiceExporter.class);
                if (exporters.isEmpty()) {
                    throw new IllegalArgumentException("No service exporters are defined within the context, can't register remote service bean [" + beanName + "]");
                }
                if (exporters.size() > 1) {
                    throw new IllegalStateException("More than one service exporter are defined within the context, please specify the exact service exported to register with");
                }
                exporter = (SpaceRemotingServiceExporter)exporters.values().iterator().next();
            }
            exporter.addService(beanName, bean);
        }
        return bean;
    }

    public boolean postProcessAfterInstantiation(final Object bean, String beanName) throws BeansException {
        Class beanClass = AopUtils.getTargetClass((Object)bean);
        if (beanClass == null) {
            return true;
        }
        ReflectionUtils.doWithFields((Class)beanClass, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                ExecutorProxy executorProxy;
                EventDrivenProxy eventDrivenProxy;
                EventDrivenScriptingExecutor eventDrivenScriptingExecutor;
                ExecutorScriptingExecutor executorScriptingExecutor = field.getAnnotation(ExecutorScriptingExecutor.class);
                if (executorScriptingExecutor != null) {
                    ExecutorSpaceRemotingProxyFactoryBean factoryBean = new ExecutorSpaceRemotingProxyFactoryBean();
                    factoryBean.setGigaSpace(RemotingAnnotationBeanPostProcessor.this.findGigaSpaceByName(executorScriptingExecutor.gigaSpace()));
                    factoryBean.setTimeout(executorScriptingExecutor.timeout());
                    factoryBean.setMetaArgumentsHandler(new ScriptingMetaArgumentsHandler());
                    factoryBean.setRemoteInvocationAspect(new LazyLoadingRemoteInvocationAspect());
                    factoryBean.setRemoteRoutingHandler(new ScriptingRemoteRoutingHandler());
                    factoryBean.setServiceInterface(ScriptingExecutor.class);
                    factoryBean.afterPropertiesSet();
                    field.setAccessible(true);
                    field.set(bean, factoryBean.getObject());
                }
                if ((eventDrivenScriptingExecutor = field.getAnnotation(EventDrivenScriptingExecutor.class)) != null) {
                    EventDrivenSpaceRemotingProxyFactoryBean factoryBean = new EventDrivenSpaceRemotingProxyFactoryBean();
                    factoryBean.setTimeout(eventDrivenScriptingExecutor.timeout());
                    factoryBean.setFifo(eventDrivenScriptingExecutor.fifo());
                    factoryBean.setGigaSpace(RemotingAnnotationBeanPostProcessor.this.findGigaSpaceByName(eventDrivenScriptingExecutor.gigaSpace()));
                    factoryBean.setMetaArgumentsHandler(new ScriptingMetaArgumentsHandler());
                    factoryBean.setRemoteInvocationAspect(new LazyLoadingRemoteInvocationAspect());
                    factoryBean.setRemoteRoutingHandler(new ScriptingRemoteRoutingHandler());
                    factoryBean.setServiceInterface(ScriptingExecutor.class);
                    factoryBean.afterPropertiesSet();
                    field.setAccessible(true);
                    field.set(bean, factoryBean.getObject());
                }
                if ((eventDrivenProxy = field.getAnnotation(EventDrivenProxy.class)) != null) {
                    EventDrivenSpaceRemotingProxyFactoryBean factoryBean = new EventDrivenSpaceRemotingProxyFactoryBean();
                    factoryBean.setTimeout(eventDrivenProxy.timeout());
                    factoryBean.setFifo(eventDrivenProxy.fifo());
                    factoryBean.setGigaSpace(RemotingAnnotationBeanPostProcessor.this.findGigaSpaceByName(eventDrivenProxy.gigaSpace()));
                    factoryBean.setAsyncMethodPrefix(eventDrivenProxy.asyncMethodPrefix());
                    factoryBean.setMetaArgumentsHandler((MetaArgumentsHandler)RemotingUtils.createByClassOrFindByName(RemotingAnnotationBeanPostProcessor.this.applicationContext, eventDrivenProxy.metaArgumentsHandler(), eventDrivenProxy.metaArgumentsHandlerType()));
                    factoryBean.setRemoteInvocationAspect((RemoteInvocationAspect)RemotingUtils.createByClassOrFindByName(RemotingAnnotationBeanPostProcessor.this.applicationContext, eventDrivenProxy.remoteInvocationAspect(), eventDrivenProxy.remoteInvocationAspectType()));
                    factoryBean.setRemoteRoutingHandler((RemoteRoutingHandler)RemotingUtils.createByClassOrFindByName(RemotingAnnotationBeanPostProcessor.this.applicationContext, eventDrivenProxy.remoteRoutingHandler(), eventDrivenProxy.remoteRoutingHandlerType()));
                    factoryBean.setServiceInterface(field.getType());
                    factoryBean.afterPropertiesSet();
                    field.setAccessible(true);
                    field.set(bean, factoryBean.getObject());
                }
                if ((executorProxy = field.getAnnotation(ExecutorProxy.class)) != null) {
                    ExecutorSpaceRemotingProxyFactoryBean factoryBean = new ExecutorSpaceRemotingProxyFactoryBean();
                    factoryBean.setGigaSpace(RemotingAnnotationBeanPostProcessor.this.findGigaSpaceByName(executorProxy.gigaSpace()));
                    factoryBean.setTimeout(executorProxy.timeout());
                    factoryBean.setBroadcast(executorProxy.broadcast());
                    factoryBean.setMetaArgumentsHandler((MetaArgumentsHandler)RemotingUtils.createByClassOrFindByName(RemotingAnnotationBeanPostProcessor.this.applicationContext, executorProxy.metaArgumentsHandler(), executorProxy.metaArgumentsHandlerType()));
                    factoryBean.setRemoteInvocationAspect((RemoteInvocationAspect)RemotingUtils.createByClassOrFindByName(RemotingAnnotationBeanPostProcessor.this.applicationContext, executorProxy.remoteInvocationAspect(), executorProxy.remoteInvocationAspectType()));
                    factoryBean.setRemoteRoutingHandler((RemoteRoutingHandler)RemotingUtils.createByClassOrFindByName(RemotingAnnotationBeanPostProcessor.this.applicationContext, executorProxy.remoteRoutingHandler(), executorProxy.remoteRoutingHandlerType()));
                    factoryBean.setRemoteResultReducer((RemoteResultReducer)RemotingUtils.createByClassOrFindByName(RemotingAnnotationBeanPostProcessor.this.applicationContext, executorProxy.remoteResultReducer(), executorProxy.remoteResultReducerType()));
                    factoryBean.setReturnFirstResult(executorProxy.returnFirstResult());
                    factoryBean.setServiceInterface(field.getType());
                    factoryBean.afterPropertiesSet();
                    field.setAccessible(true);
                    field.set(bean, factoryBean.getObject());
                }
            }
        });
        return true;
    }

    protected GigaSpace findGigaSpaceByName(String gsName) throws NoSuchBeanDefinitionException {
        this.initMapsIfNecessary();
        if (gsName == null || "".equals(gsName)) {
            if (this.uniqueGs != null) {
                return this.uniqueGs;
            }
            throw new NoSuchBeanDefinitionException("No GigaSpaces name given and factory contains several");
        }
        GigaSpace namedGs = this.gsByName.get(gsName);
        if (namedGs == null) {
            throw new NoSuchBeanDefinitionException("No GigaSpaces found for name [" + gsName + "]");
        }
        return namedGs;
    }

    private synchronized void initMapsIfNecessary() {
        if (this.gsByName == null) {
            this.gsByName = new HashMap<String, GigaSpace>();
            for (String gsName : BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, GigaSpace.class)) {
                GigaSpace gs = (GigaSpace)this.applicationContext.getBean(gsName);
                this.gsByName.put(gsName, gs);
            }
            if (this.gsByName.isEmpty()) {
                String[] gsNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, GigaSpace.class);
                if (gsNames.length == 1) {
                    this.uniqueGs = (GigaSpace)this.applicationContext.getBean(gsNames[0]);
                }
            } else if (this.gsByName.size() == 1) {
                this.uniqueGs = this.gsByName.values().iterator().next();
            }
            if (this.gsByName.isEmpty() && this.uniqueGs == null) {
                logger.warn((Object)"No named gs instances defined and not exactly one anonymous one: cannot inject");
            }
        }
    }
}

