/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.remoting;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.openspaces.pu.service.PlainServiceDetails;

public class RemotingServiceDetails
extends PlainServiceDetails {
    private static final long serialVersionUID = 5538531964331522954L;
    public static final String SERVICE_TYPE = "remoting";

    public RemotingServiceDetails() {
    }

    public RemotingServiceDetails(String id, RemoteService[] remoteServices) {
        super(id, SERVICE_TYPE, "", "Remoting Service", "Remoting Service");
        for (RemoteService service : remoteServices) {
            this.getAttributes().put(service.getBeanId(), service);
        }
    }

    public RemoteService getRemoteService(String id) {
        return (RemoteService)this.getAttributes().get(id);
    }

    public RemoteService[] getRemoteServices() {
        ArrayList<RemoteService> remoteServices = new ArrayList<RemoteService>();
        for (Object attr : this.getAttributes().values()) {
            if (!(attr instanceof RemoteService)) continue;
            remoteServices.add((RemoteService)attr);
        }
        return remoteServices.toArray(new RemoteService[remoteServices.size()]);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }

    public static class Attributes {
    }

    public static class RemoteService
    implements Externalizable {
        private static final long serialVersionUID = -8527660067530155L;
        private String beanId;
        private String className;

        public RemoteService() {
        }

        public RemoteService(String beanId, String className) {
            this.beanId = beanId;
            this.className = className;
        }

        public String getBeanId() {
            return this.beanId;
        }

        public String getClassName() {
            return this.className;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.beanId);
            out.writeObject(this.className);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.beanId = (String)in.readObject();
            this.className = (String)in.readObject();
        }

        public String toString() {
            return "[" + this.beanId + "], class [" + this.className + "]";
        }
    }
}

