/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.remoting;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.openspaces.pu.service.PlainServiceMonitors;
import org.openspaces.remoting.RemotingServiceDetails;

public class RemotingServiceMonitors
extends PlainServiceMonitors {
    private static final long serialVersionUID = -7084565982937002812L;

    public RemotingServiceMonitors() {
    }

    public RemotingServiceMonitors(String id, long processed, long failed, RemoteServiceStats[] remoteServiceStats) {
        super(id);
        this.getMonitors().put("processed", processed);
        this.getMonitors().put("failed", failed);
        for (RemoteServiceStats stats : remoteServiceStats) {
            this.getMonitors().put(stats.getBeanId(), stats);
        }
    }

    public RemotingServiceDetails getRemotingDetails() {
        return (RemotingServiceDetails)this.getDetails();
    }

    public long getProcessed() {
        return (Long)this.getMonitors().get("processed");
    }

    public long getFailed() {
        return (Long)this.getMonitors().get("failed");
    }

    public RemoteServiceStats getRemoteServiceStats(String id) {
        return (RemoteServiceStats)this.getMonitors().get(id);
    }

    public RemoteServiceStats[] getRemoteServiceStats() {
        ArrayList<RemoteServiceStats> remoteServiceStats = new ArrayList<RemoteServiceStats>();
        for (Object monitor : this.getMonitors().values()) {
            if (!(monitor instanceof RemoteServiceStats)) continue;
            remoteServiceStats.add((RemoteServiceStats)monitor);
        }
        return remoteServiceStats.toArray(new RemoteServiceStats[remoteServiceStats.size()]);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }

    public static class RemoteServiceStats
    implements Externalizable {
        private static final long serialVersionUID = 2541853099219414723L;
        private String beanId;
        private long processed;
        private long failed;

        public RemoteServiceStats() {
        }

        public RemoteServiceStats(String beanId, long processed, long failed) {
            this.beanId = beanId;
            this.processed = processed;
            this.failed = failed;
        }

        public String getBeanId() {
            return this.beanId;
        }

        public long getProcessed() {
            return this.processed;
        }

        public long getFailed() {
            return this.failed;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.beanId);
            out.writeLong(this.processed);
            out.writeLong(this.failed);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.beanId = (String)in.readObject();
            this.processed = in.readLong();
            this.failed = in.readLong();
        }

        public String toString() {
            return "[" + this.beanId + "], processed [" + this.processed + "], failed [" + this.failed + "]";
        }
    }

    public static class Attributes {
        public static final String PROCESSED = "processed";
        public static final String FAILED = "failed";
    }
}

