/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.remoting;

import com.gigaspaces.internal.reflection.IMethod;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import com.gigaspaces.internal.reflection.standard.StandardMethod;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class RemotingUtils {
    public static Object createByClassOrFindByName(ApplicationContext applicationContext, String name, Class clazz) throws NoSuchBeanDefinitionException {
        if (StringUtils.hasLength((String)name)) {
            return applicationContext.getBean(name);
        }
        if (!Object.class.equals((Object)clazz)) {
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                throw new NoSuchBeanDefinitionException("Failed to create class [" + clazz + "]");
            }
        }
        return null;
    }

    public static Map<MethodHash, IMethod> buildHashToMethodLookupForInterface(Class service, boolean useFastReflection) {
        try {
            Class[] interfaces;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DigestOutputStream dos = new DigestOutputStream(bos, digest);
            DataOutputStream out = new DataOutputStream(dos);
            HashSet<Method> methodSet = new HashSet<Method>();
            HashMap<MethodHash, IMethod> map = new HashMap<MethodHash, IMethod>();
            for (Class inf : interfaces = RemotingUtils.getAllInterfacesForInterface(service)) {
                for (Method method : inf.getMethods()) {
                    Object imethod = useFastReflection ? ReflectionUtil.createMethod((Method)method) : new StandardMethod(method);
                    digest.reset();
                    bos.reset();
                    RemotingUtils.serializeMethod(method, out);
                    map.put(new MethodHash(digest.digest()), (IMethod)imethod);
                    methodSet.add(method);
                }
            }
            Method toStringMethod = Object.class.getMethod("toString", new Class[0]);
            if (!methodSet.contains(toStringMethod)) {
                digest.reset();
                bos.reset();
                RemotingUtils.serializeMethod(toStringMethod, out);
                Object imethod = useFastReflection ? ReflectionUtil.createMethod((Method)toStringMethod) : new StandardMethod(toStringMethod);
                map.put(new MethodHash(digest.digest()), (IMethod)imethod);
            }
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build method lookup hash", e);
        }
    }

    public static Map<Method, MethodHash> buildMethodToHashLookupForInterface(Class service, String asyncPrefix) {
        try {
            Class[] interfaces;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DigestOutputStream dos = new DigestOutputStream(bos, digest);
            DataOutputStream out = new DataOutputStream(dos);
            HashMap<Method, MethodHash> map = new HashMap<Method, MethodHash>();
            for (Class inf : interfaces = RemotingUtils.getAllInterfacesForInterface(service)) {
                for (Method method : inf.getMethods()) {
                    if (method.getName().startsWith(asyncPrefix)) {
                        String nonAsyncMethodName = method.getName().substring(asyncPrefix.length());
                        nonAsyncMethodName = StringUtils.uncapitalize((String)nonAsyncMethodName);
                        Method nonAsyncMethod = inf.getMethod(nonAsyncMethodName, method.getParameterTypes());
                        digest.reset();
                        bos.reset();
                        RemotingUtils.serializeMethod(nonAsyncMethod, out);
                        map.put(method, new MethodHash(digest.digest()));
                        continue;
                    }
                    digest.reset();
                    bos.reset();
                    RemotingUtils.serializeMethod(method, out);
                    map.put(method, new MethodHash(digest.digest()));
                }
            }
            Method toStringMethod = Object.class.getMethod("toString", new Class[0]);
            if (!map.containsKey(toStringMethod)) {
                digest.reset();
                bos.reset();
                RemotingUtils.serializeMethod(toStringMethod, out);
                map.put(toStringMethod, new MethodHash(digest.digest()));
            }
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build method lookup hash", e);
        }
    }

    private static void serializeMethod(Method method, DataOutput out) throws IOException {
        RemotingUtils.serializeMethod(method.getName(), method, out);
    }

    private static void serializeMethod(String methodName, Method method, DataOutput out) throws IOException {
        out.writeUTF(methodName);
        for (Class<?> paramType : method.getParameterTypes()) {
            out.writeUTF(paramType.getName());
        }
    }

    private static Class[] getAllInterfacesForInterface(Class service) {
        LinkedHashSet<Class> interfaces = new LinkedHashSet<Class>();
        RemotingUtils.getAllInterfacesForInterface(service, interfaces);
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    private static void getAllInterfacesForInterface(Class service, Set<Class> interfaces) {
        if (service.getInterfaces() != null && service.getInterfaces().length > 0) {
            for (Class<?> inf : service.getInterfaces()) {
                RemotingUtils.getAllInterfacesForInterface(inf, interfaces);
            }
        }
        interfaces.add(service);
    }

    public static class MethodHash
    implements Externalizable {
        private static final long serialVersionUID = 872088354835809493L;
        private byte[] hash;

        public MethodHash() {
        }

        public MethodHash(byte[] hash) {
            this.hash = hash;
        }

        public byte[] hash() {
            return this.hash;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.hash.length);
            out.write(this.hash);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.hash = new byte[in.readInt()];
            in.readFully(this.hash);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodHash that = (MethodHash)o;
            return Arrays.equals(this.hash, that.hash);
        }

        public int hashCode() {
            return this.hash != null ? Arrays.hashCode(this.hash) : 0;
        }
    }
}

